@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Describes the connection monitor test group.
 * @property destinations List of destination endpoint names.
 * @property disable Value indicating whether test group is disabled.
 * @property name The name of the connection monitor test group.
 * @property sources List of source endpoint names.
 * @property testConfigurations List of test configuration names.
 */
public data class ConnectionMonitorTestGroupResponse(
    public val destinations: List<String>,
    public val disable: Boolean? = null,
    public val name: String,
    public val sources: List<String>,
    public val testConfigurations: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ConnectionMonitorTestGroupResponse):
            ConnectionMonitorTestGroupResponse = ConnectionMonitorTestGroupResponse(
            destinations = javaType.destinations().map({ args0 -> args0 }),
            disable = javaType.disable().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            sources = javaType.sources().map({ args0 -> args0 }),
            testConfigurations = javaType.testConfigurations().map({ args0 -> args0 }),
        )
    }
}
