@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Trusted Root certificates properties for tls.
 * @property keyVaultSecretId Secret Id of (base-64 encoded unencrypted pfx) 'Secret' or 'Certificate' object stored in KeyVault.
 * @property name Name of the CA certificate.
 */
public data class FirewallPolicyCertificateAuthorityResponse(
    public val keyVaultSecretId: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyCertificateAuthorityResponse):
            FirewallPolicyCertificateAuthorityResponse = FirewallPolicyCertificateAuthorityResponse(
            keyVaultSecretId = javaType.keyVaultSecretId().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
