@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Firewall Policy NAT Rule.
 * @property action The action type of a Nat rule.
 * @property name The name of the rule.
 * @property priority Priority of the Firewall Policy Rule resource.
 * @property ruleCondition The match conditions for incoming traffic.
 * @property ruleType The type of the rule.
 * Expected value is 'FirewallPolicyNatRule'.
 * @property translatedAddress The translated address for this NAT rule.
 * @property translatedPort The translated port for this NAT rule.
 */
public data class FirewallPolicyNatRuleResponse(
    public val action: FirewallPolicyNatRuleActionResponse? = null,
    public val name: String? = null,
    public val priority: Int? = null,
    public val ruleCondition: Any? = null,
    public val ruleType: String,
    public val translatedAddress: String? = null,
    public val translatedPort: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FirewallPolicyNatRuleResponse):
            FirewallPolicyNatRuleResponse = FirewallPolicyNatRuleResponse(
            action = javaType.action().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FirewallPolicyNatRuleActionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            ruleCondition = javaType.ruleCondition().map({ args0 -> args0 }).orElse(null),
            ruleType = javaType.ruleType(),
            translatedAddress = javaType.translatedAddress().map({ args0 -> args0 }).orElse(null),
            translatedPort = javaType.translatedPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
