@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Frontend IP address of the load balancer.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property gatewayLoadBalancer The reference to gateway load balancer frontend IP.
 * @property id Resource ID.
 * @property inboundNatPools An array of references to inbound pools that use this frontend IP.
 * @property inboundNatRules An array of references to inbound rules that use this frontend IP.
 * @property loadBalancingRules An array of references to load balancing rules that use this frontend IP.
 * @property name The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.
 * @property outboundRules An array of references to outbound rules that use this frontend IP.
 * @property privateIPAddress The private IP address of the IP configuration.
 * @property privateIPAddressVersion Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.
 * @property privateIPAllocationMethod The Private IP allocation method.
 * @property provisioningState The provisioning state of the frontend IP configuration resource.
 * @property publicIPAddress The reference to the Public IP resource.
 * @property publicIPPrefix The reference to the Public IP Prefix resource.
 * @property subnet The reference to the subnet resource.
 * @property type Type of the resource.
 * @property zones A list of availability zones denoting the IP allocated for the resource needs to come from.
 */
public data class FrontendIPConfigurationResponse(
    public val etag: String,
    public val gatewayLoadBalancer: SubResourceResponse? = null,
    public val id: String? = null,
    public val inboundNatPools: List<SubResourceResponse>,
    public val inboundNatRules: List<SubResourceResponse>,
    public val loadBalancingRules: List<SubResourceResponse>,
    public val name: String? = null,
    public val outboundRules: List<SubResourceResponse>,
    public val privateIPAddress: String? = null,
    public val privateIPAddressVersion: String? = null,
    public val privateIPAllocationMethod: String? = null,
    public val provisioningState: String,
    public val publicIPAddress: PublicIPAddressResponse? = null,
    public val publicIPPrefix: SubResourceResponse? = null,
    public val subnet: SubnetResponse? = null,
    public val type: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.FrontendIPConfigurationResponse):
            FrontendIPConfigurationResponse = FrontendIPConfigurationResponse(
            etag = javaType.etag(),
            gatewayLoadBalancer = javaType.gatewayLoadBalancer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            inboundNatPools = javaType.inboundNatPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            inboundNatRules = javaType.inboundNatRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            loadBalancingRules = javaType.loadBalancingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            outboundRules = javaType.outboundRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
            privateIPAddressVersion = javaType.privateIPAddressVersion().map({ args0 -> args0 }).orElse(null),
            privateIPAllocationMethod = javaType.privateIPAllocationMethod().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicIPAddress = javaType.publicIPAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            publicIPPrefix = javaType.publicIPPrefix().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
