@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A DDoS protection plan in a resource group.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the DDoS protection plan resource.
 * @property publicIPAddresses The list of public IPs associated with the DDoS protection plan resource. This list is read-only.
 * @property resourceGuid The resource GUID property of the DDoS protection plan resource. It uniquely identifies the resource, even if the user changes its name or migrate the resource across subscriptions or resource groups.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualNetworks The list of virtual networks associated with the DDoS protection plan resource. This list is read-only.
 */
public data class GetDdosProtectionPlanResult(
    public val etag: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val publicIPAddresses: List<SubResourceResponse>,
    public val resourceGuid: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualNetworks: List<SubResourceResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetDdosProtectionPlanResult):
            GetDdosProtectionPlanResult = GetDdosProtectionPlanResult(
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publicIPAddresses = javaType.publicIPAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            resourceGuid = javaType.resourceGuid(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualNetworks = javaType.virtualNetworks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
