@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A flow log resource.
 * @property enabled Flag to enable/disable flow logging.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property flowAnalyticsConfiguration Parameters that define the configuration of traffic analytics.
 * @property format Parameters that define the flow log format.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the flow log.
 * @property retentionPolicy Parameters that define the retention policy for flow log.
 * @property storageId ID of the storage account which is used to store the flow log.
 * @property tags Resource tags.
 * @property targetResourceGuid Guid of network security group to which flow log will be applied.
 * @property targetResourceId ID of network security group to which flow log will be applied.
 * @property type Resource type.
 */
public data class GetFlowLogResult(
    public val enabled: Boolean? = null,
    public val etag: String,
    public val flowAnalyticsConfiguration: TrafficAnalyticsPropertiesResponse? = null,
    public val format: FlowLogFormatParametersResponse? = null,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val retentionPolicy: RetentionPolicyParametersResponse? = null,
    public val storageId: String,
    public val tags: Map<String, String>? = null,
    public val targetResourceGuid: String,
    public val targetResourceId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetFlowLogResult):
            GetFlowLogResult = GetFlowLogResult(
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            flowAnalyticsConfiguration = javaType.flowAnalyticsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.TrafficAnalyticsPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            format = javaType.format().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FlowLogFormatParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            retentionPolicy = javaType.retentionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RetentionPolicyParametersResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageId = javaType.storageId(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceGuid = javaType.targetResourceGuid(),
            targetResourceId = javaType.targetResourceId(),
            type = javaType.type(),
        )
    }
}
