@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Network profile resource.
 * @property containerNetworkInterfaceConfigurations List of chid container network interface configurations.
 * @property containerNetworkInterfaces List of child container network interfaces.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the network profile resource.
 * @property resourceGuid The resource GUID property of the network profile resource.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetNetworkProfileResult(
    public val containerNetworkInterfaceConfigurations:
    List<ContainerNetworkInterfaceConfigurationResponse>? = null,
    public val containerNetworkInterfaces: List<ContainerNetworkInterfaceResponse>,
    public val etag: String,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNetworkProfileResult):
            GetNetworkProfileResult = GetNetworkProfileResult(
            containerNetworkInterfaceConfigurations = javaType.containerNetworkInterfaceConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ContainerNetworkInterfaceConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            containerNetworkInterfaces = javaType.containerNetworkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ContainerNetworkInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
