@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The Network Security Perimeter resource
 * @property description A description of the network security perimeter.
 * @property displayName A friendly name for the network security perimeter.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the scope assignment resource.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetNetworkSecurityPerimeterResult(
    public val description: String? = null,
    public val displayName: String? = null,
    public val etag: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNetworkSecurityPerimeterResult):
            GetNetworkSecurityPerimeterResult = GetNetworkSecurityPerimeterResult(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
