@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The network security perimeter profile resource
 * @property accessRulesVersion Version number that increases with every update to access rules within the profile.
 * @property diagnosticSettingsVersion Version number that increases with every update to diagnostic settings within the profile.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetNspProfileResult(
    public val accessRulesVersion: String,
    public val diagnosticSettingsVersion: String,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetNspProfileResult):
            GetNspProfileResult = GetNspProfileResult(
            accessRulesVersion = javaType.accessRulesVersion(),
            diagnosticSettingsVersion = javaType.diagnosticSettingsVersion(),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
