@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VirtualHubRouteTableV2 Resource.
 * @property attachedConnections List of all connections attached to this route table v2.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the virtual hub route table v2 resource.
 * @property routes List of all routes.
 */
public data class GetVirtualHubRouteTableV2Result(
    public val attachedConnections: List<String>? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val routes: List<VirtualHubRouteV2Response>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualHubRouteTableV2Result):
            GetVirtualHubRouteTableV2Result = GetVirtualHubRouteTableV2Result(
            attachedConnections = javaType.attachedConnections().map({ args0 -> args0 }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualHubRouteV2Response.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
