@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A common class for general resource information.
 * @property authorizationKey The authorizationKey.
 * @property connectionMode The connection mode for this connection.
 * @property connectionProtocol Connection protocol used for this connection.
 * @property connectionStatus Virtual Network Gateway connection status.
 * @property connectionType Gateway connection type.
 * @property dpdTimeoutSeconds The dead peer detection timeout of this connection in seconds.
 * @property egressBytesTransferred The egress bytes transferred in this connection.
 * @property egressNatRules List of egress NatRules.
 * @property enableBgp EnableBgp flag.
 * @property enablePrivateLinkFastPath Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property expressRouteGatewayBypass Bypass ExpressRoute Gateway for data forwarding.
 * @property gatewayCustomBgpIpAddresses GatewayCustomBgpIpAddresses to be used for virtual network gateway Connection.
 * @property id Resource ID.
 * @property ingressBytesTransferred The ingress bytes transferred in this connection.
 * @property ingressNatRules List of ingress NatRules.
 * @property ipsecPolicies The IPSec Policies to be considered by this connection.
 * @property localNetworkGateway2 The reference to local network gateway resource.
 * @property location Resource location.
 * @property name Resource name.
 * @property peer The reference to peerings resource.
 * @property provisioningState The provisioning state of the virtual network gateway connection resource.
 * @property resourceGuid The resource GUID property of the virtual network gateway connection resource.
 * @property routingWeight The routing weight.
 * @property sharedKey The IPSec shared key.
 * @property tags Resource tags.
 * @property trafficSelectorPolicies The Traffic Selector Policies to be considered by this connection.
 * @property tunnelConnectionStatus Collection of all tunnels' connection health status.
 * @property type Resource type.
 * @property useLocalAzureIpAddress Use private local Azure IP for the connection.
 * @property usePolicyBasedTrafficSelectors Enable policy-based traffic selectors.
 * @property virtualNetworkGateway1 The reference to virtual network gateway resource.
 * @property virtualNetworkGateway2 The reference to virtual network gateway resource.
 */
public data class GetVirtualNetworkGatewayConnectionResult(
    public val authorizationKey: String? = null,
    public val connectionMode: String? = null,
    public val connectionProtocol: String? = null,
    public val connectionStatus: String,
    public val connectionType: String,
    public val dpdTimeoutSeconds: Int? = null,
    public val egressBytesTransferred: Double,
    public val egressNatRules: List<SubResourceResponse>? = null,
    public val enableBgp: Boolean? = null,
    public val enablePrivateLinkFastPath: Boolean? = null,
    public val etag: String,
    public val expressRouteGatewayBypass: Boolean? = null,
    public val gatewayCustomBgpIpAddresses: List<GatewayCustomBgpIpAddressIpConfigurationResponse>? =
        null,
    public val id: String? = null,
    public val ingressBytesTransferred: Double,
    public val ingressNatRules: List<SubResourceResponse>? = null,
    public val ipsecPolicies: List<IpsecPolicyResponse>? = null,
    public val localNetworkGateway2: LocalNetworkGatewayResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val peer: SubResourceResponse? = null,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val routingWeight: Int? = null,
    public val sharedKey: String? = null,
    public val tags: Map<String, String>? = null,
    public val trafficSelectorPolicies: List<TrafficSelectorPolicyResponse>? = null,
    public val tunnelConnectionStatus: List<TunnelConnectionHealthResponse>,
    public val type: String,
    public val useLocalAzureIpAddress: Boolean? = null,
    public val usePolicyBasedTrafficSelectors: Boolean? = null,
    public val virtualNetworkGateway1: VirtualNetworkGatewayResponse,
    public val virtualNetworkGateway2: VirtualNetworkGatewayResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualNetworkGatewayConnectionResult):
            GetVirtualNetworkGatewayConnectionResult = GetVirtualNetworkGatewayConnectionResult(
            authorizationKey = javaType.authorizationKey().map({ args0 -> args0 }).orElse(null),
            connectionMode = javaType.connectionMode().map({ args0 -> args0 }).orElse(null),
            connectionProtocol = javaType.connectionProtocol().map({ args0 -> args0 }).orElse(null),
            connectionStatus = javaType.connectionStatus(),
            connectionType = javaType.connectionType(),
            dpdTimeoutSeconds = javaType.dpdTimeoutSeconds().map({ args0 -> args0 }).orElse(null),
            egressBytesTransferred = javaType.egressBytesTransferred(),
            egressNatRules = javaType.egressNatRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            enableBgp = javaType.enableBgp().map({ args0 -> args0 }).orElse(null),
            enablePrivateLinkFastPath = javaType.enablePrivateLinkFastPath().map({ args0 ->
                args0
            }).orElse(null),
            etag = javaType.etag(),
            expressRouteGatewayBypass = javaType.expressRouteGatewayBypass().map({ args0 ->
                args0
            }).orElse(null),
            gatewayCustomBgpIpAddresses = javaType.gatewayCustomBgpIpAddresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.GatewayCustomBgpIpAddressIpConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ingressBytesTransferred = javaType.ingressBytesTransferred(),
            ingressNatRules = javaType.ingressNatRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            ipsecPolicies = javaType.ipsecPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            localNetworkGateway2 = javaType.localNetworkGateway2().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.LocalNetworkGatewayResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            peer = javaType.peer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            routingWeight = javaType.routingWeight().map({ args0 -> args0 }).orElse(null),
            sharedKey = javaType.sharedKey().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            trafficSelectorPolicies = javaType.trafficSelectorPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.TrafficSelectorPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            tunnelConnectionStatus = javaType.tunnelConnectionStatus().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.TunnelConnectionHealthResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            useLocalAzureIpAddress = javaType.useLocalAzureIpAddress().map({ args0 -> args0 }).orElse(null),
            usePolicyBasedTrafficSelectors = javaType.usePolicyBasedTrafficSelectors().map({ args0 ->
                args0
            }).orElse(null),
            virtualNetworkGateway1 = javaType.virtualNetworkGateway1().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkGatewayResponse.Companion.toKotlin(args0)
            }),
            virtualNetworkGateway2 = javaType.virtualNetworkGateway2().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkGatewayResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
