@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Load balancing settings for a backend pool
 * @property enabledState Whether to enable health probes to be made against backends defined under backendPools. Health probes can only be disabled if there is a single enabled backend in single enabled backend pool.
 * @property healthProbeMethod Configures which HTTP method to use to probe the backends defined under backendPools.
 * @property id Resource ID.
 * @property intervalInSeconds The number of seconds between health probes.
 * @property name Resource name.
 * @property path The path to use for the health probe. Default is /
 * @property protocol Protocol scheme to use for this probe
 * @property resourceState Resource status.
 * @property type Resource type.
 */
public data class HealthProbeSettingsModelResponse(
    public val enabledState: String? = null,
    public val healthProbeMethod: String? = null,
    public val id: String? = null,
    public val intervalInSeconds: Int? = null,
    public val name: String? = null,
    public val path: String? = null,
    public val protocol: String? = null,
    public val resourceState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.HealthProbeSettingsModelResponse):
            HealthProbeSettingsModelResponse = HealthProbeSettingsModelResponse(
            enabledState = javaType.enabledState().map({ args0 -> args0 }).orElse(null),
            healthProbeMethod = javaType.healthProbeMethod().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            intervalInSeconds = javaType.intervalInSeconds().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            resourceState = javaType.resourceState(),
            type = javaType.type(),
        )
    }
}
