@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Hub Item.
 * @property resourceId Resource Id.
 * @property resourceType Resource Type.
 */
public data class HubResponse(
    public val resourceId: String? = null,
    public val resourceType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.HubResponse): HubResponse =
            HubResponse(
                resourceId = javaType.resourceId().map({ args0 -> args0 }).orElse(null),
                resourceType = javaType.resourceType().map({ args0 -> args0 }).orElse(null),
            )
    }
}
