@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * RouteTable route.
 * @property destinationType The type of destinations (eg: CIDR, ResourceId, Service).
 * @property destinations List of all destinations.
 * @property name The name of the Route that is unique within a RouteTable. This name can be used to access this route.
 * @property nextHop NextHop resource ID.
 * @property nextHopType The type of next hop (eg: ResourceId).
 */
public data class HubRouteResponse(
    public val destinationType: String,
    public val destinations: List<String>,
    public val name: String,
    public val nextHop: String,
    public val nextHopType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.HubRouteResponse):
            HubRouteResponse = HubRouteResponse(
            destinationType = javaType.destinationType(),
            destinations = javaType.destinations().map({ args0 -> args0 }),
            name = javaType.name(),
            nextHop = javaType.nextHop(),
            nextHopType = javaType.nextHopType(),
        )
    }
}
