@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Result of the request to list Effective Virtual Network. It contains a list of groups and a URL link to get the next set of results.
 * @property skipToken When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
 * @property value Gets a page of EffectiveVirtualNetwork
 */
public data class ListEffectiveVirtualNetworkByNetworkManagerResult(
    public val skipToken: String? = null,
    public val `value`: List<EffectiveVirtualNetworkResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ListEffectiveVirtualNetworkByNetworkManagerResult):
            ListEffectiveVirtualNetworkByNetworkManagerResult =
            ListEffectiveVirtualNetworkByNetworkManagerResult(
                skipToken = javaType.skipToken().map({ args0 -> args0 }).orElse(null),
                `value` = javaType.`value`().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.EffectiveVirtualNetworkResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
