@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Exclude variables from managed rule evaluation.
 * @property matchVariable The variable type to be excluded.
 * @property selector Selector value for which elements in the collection this exclusion applies to.
 * @property selectorMatchOperator Comparison operator to apply to the selector when specifying which elements in the collection this exclusion applies to.
 */
public data class ManagedRuleExclusionResponse(
    public val matchVariable: String,
    public val selector: String,
    public val selectorMatchOperator: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ManagedRuleExclusionResponse):
            ManagedRuleExclusionResponse = ManagedRuleExclusionResponse(
            matchVariable = javaType.matchVariable(),
            selector = javaType.selector(),
            selectorMatchOperator = javaType.selectorMatchOperator(),
        )
    }
}
