@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines a managed rule group override setting.
 * @property ruleGroupName The managed rule group to override.
 * @property rules List of rules that will be disabled. If none specified, all rules in the group will be disabled.
 */
public data class ManagedRuleGroupOverrideResponse(
    public val ruleGroupName: String,
    public val rules: List<ManagedRuleOverrideResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ManagedRuleGroupOverrideResponse):
            ManagedRuleGroupOverrideResponse = ManagedRuleGroupOverrideResponse(
            ruleGroupName = javaType.ruleGroupName(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ManagedRuleOverrideResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
