@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Define match conditions.
 * @property matchValues Match value.
 * @property matchVariables List of match variables.
 * @property negationConditon Whether this is negate condition or not.
 * @property operator The operator to be matched.
 * @property transforms List of transforms.
 */
public data class MatchConditionResponse(
    public val matchValues: List<String>,
    public val matchVariables: List<MatchVariableResponse>,
    public val negationConditon: Boolean? = null,
    public val `operator`: String,
    public val transforms: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.MatchConditionResponse):
            MatchConditionResponse = MatchConditionResponse(
            matchValues = javaType.matchValues().map({ args0 -> args0 }),
            matchVariables = javaType.matchVariables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.MatchVariableResponse.Companion.toKotlin(args0)
                })
            }),
            negationConditon = javaType.negationConditon().map({ args0 -> args0 }).orElse(null),
            `operator` = javaType.`operator`(),
            transforms = javaType.transforms().map({ args0 -> args0 }),
        )
    }
}
