@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Individual port mappings for inbound NAT rule created for backend pool.
 * @property backendPort Backend port.
 * @property frontendPort Frontend port.
 * @property inboundNatRuleName Name of inbound NAT rule.
 */
public data class NatRulePortMappingResponse(
    public val backendPort: Int? = null,
    public val frontendPort: Int? = null,
    public val inboundNatRuleName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.NatRulePortMappingResponse):
            NatRulePortMappingResponse = NatRulePortMappingResponse(
            backendPort = javaType.backendPort().map({ args0 -> args0 }).orElse(null),
            frontendPort = javaType.frontendPort().map({ args0 -> args0 }).orElse(null),
            inboundNatRuleName = javaType.inboundNatRuleName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
