@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Quality of Service defines the traffic configuration between endpoints. Mandatory to have one marking.
 * @property destinationIpRanges Destination IP ranges.
 * @property destinationPortRanges Destination port ranges.
 * @property markings List of markings to be used in the configuration.
 * @property protocol RNM supported protocol types.
 * @property sourceIpRanges Source IP ranges.
 * @property sourcePortRanges Sources port ranges.
 */
public data class QosDefinitionResponse(
    public val destinationIpRanges: List<QosIpRangeResponse>? = null,
    public val destinationPortRanges: List<QosPortRangeResponse>? = null,
    public val markings: List<Int>? = null,
    public val protocol: String? = null,
    public val sourceIpRanges: List<QosIpRangeResponse>? = null,
    public val sourcePortRanges: List<QosPortRangeResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.QosDefinitionResponse):
            QosDefinitionResponse = QosDefinitionResponse(
            destinationIpRanges = javaType.destinationIpRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.QosIpRangeResponse.Companion.toKotlin(args0)
                })
            }),
            destinationPortRanges = javaType.destinationPortRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.QosPortRangeResponse.Companion.toKotlin(args0)
                })
            }),
            markings = javaType.markings().map({ args0 -> args0 }),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            sourceIpRanges = javaType.sourceIpRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.QosIpRangeResponse.Companion.toKotlin(args0)
                })
            }),
            sourcePortRanges = javaType.sourcePortRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.QosPortRangeResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
