@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ResourceNavigationLink resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property link Link to the external resource.
 * @property linkedResourceType Resource type of the linked resource.
 * @property name Name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the resource navigation link resource.
 * @property type Resource type.
 */
public data class ResourceNavigationLinkResponse(
    public val etag: String,
    public val id: String,
    public val link: String? = null,
    public val linkedResourceType: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ResourceNavigationLinkResponse):
            ResourceNavigationLinkResponse = ResourceNavigationLinkResponse(
            etag = javaType.etag(),
            id = javaType.id(),
            link = javaType.link().map({ args0 -> args0 }).orElse(null),
            linkedResourceType = javaType.linkedResourceType().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
