@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The pricing tier of the web application firewall policy.
 * @property name Name of the pricing tier.
 */
public data class SkuResponse(
    public val name: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
            )
    }
}
