@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Parameters that define the configuration of traffic analytics.
 * @property enabled Flag to enable/disable traffic analytics.
 * @property trafficAnalyticsInterval The interval in minutes which would decide how frequently TA service should do flow analytics.
 * @property workspaceId The resource guid of the attached workspace.
 * @property workspaceRegion The location of the attached workspace.
 * @property workspaceResourceId Resource Id of the attached workspace.
 */
public data class TrafficAnalyticsConfigurationPropertiesResponse(
    public val enabled: Boolean? = null,
    public val trafficAnalyticsInterval: Int? = null,
    public val workspaceId: String? = null,
    public val workspaceRegion: String? = null,
    public val workspaceResourceId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.TrafficAnalyticsConfigurationPropertiesResponse):
            TrafficAnalyticsConfigurationPropertiesResponse =
            TrafficAnalyticsConfigurationPropertiesResponse(
                enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
                trafficAnalyticsInterval = javaType.trafficAnalyticsInterval().map({ args0 -> args0 }).orElse(null),
                workspaceId = javaType.workspaceId().map({ args0 -> args0 }).orElse(null),
                workspaceRegion = javaType.workspaceRegion().map({ args0 -> args0 }).orElse(null),
                workspaceResourceId = javaType.workspaceResourceId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
