@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Describes a Virtual Machine.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class VMResponse(
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VMResponse): VMResponse =
            VMResponse(
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                location = javaType.location().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                type = javaType.type(),
            )
    }
}
