@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Reference to DNS forwarding ruleset and associated virtual network link.
 * @property id DNS Forwarding Ruleset Resource ID.
 * @property virtualNetworkLink The reference to the virtual network link.
 */
public data class VirtualNetworkDnsForwardingRulesetResponse(
    public val id: String? = null,
    public val virtualNetworkLink: SubResourceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualNetworkDnsForwardingRulesetResponse):
            VirtualNetworkDnsForwardingRulesetResponse = VirtualNetworkDnsForwardingRulesetResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            virtualNetworkLink = javaType.virtualNetworkLink().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
