@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A common class for general resource information.
 * @property activeActive ActiveActive flag.
 * @property adminState Property to indicate if the Express Route Gateway serves traffic when there are multiple Express Route Gateways in the vnet
 * @property allowRemoteVnetTraffic Configure this gateway to accept traffic from other Azure Virtual Networks. This configuration does not support connectivity to Azure Virtual WAN.
 * @property allowVirtualWanTraffic Configures this gateway to accept traffic from remote Virtual WAN networks.
 * @property bgpSettings Virtual network gateway's BGP speaker settings.
 * @property customRoutes The reference to the address space resource which represents the custom routes address space specified by the customer for virtual network gateway and VpnClient.
 * @property disableIPSecReplayProtection disableIPSecReplayProtection flag.
 * @property enableBgp Whether BGP is enabled for this virtual network gateway or not.
 * @property enableBgpRouteTranslationForNat EnableBgpRouteTranslationForNat flag.
 * @property enableDnsForwarding Whether dns forwarding is enabled or not.
 * @property enablePrivateIpAddress Whether private IP needs to be enabled on this gateway for connections or not.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property extendedLocation The extended location of type local virtual network gateway.
 * @property gatewayDefaultSite The reference to the LocalNetworkGateway resource which represents local network site having default routes. Assign Null value in case of removing existing default site setting.
 * @property gatewayType The type of this virtual network gateway.
 * @property id Resource ID.
 * @property inboundDnsForwardingEndpoint The IP address allocated by the gateway to which dns requests can be sent.
 * @property ipConfigurations IP configurations for virtual network gateway.
 * @property location Resource location.
 * @property name Resource name.
 * @property natRules NatRules for virtual network gateway.
 * @property provisioningState The provisioning state of the virtual network gateway resource.
 * @property resourceGuid The resource GUID property of the virtual network gateway resource.
 * @property sku The reference to the VirtualNetworkGatewaySku resource which represents the SKU selected for Virtual network gateway.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property vNetExtendedLocationResourceId Customer vnet resource id. VirtualNetworkGateway of type local gateway is associated with the customer vnet.
 * @property virtualNetworkGatewayPolicyGroups The reference to the VirtualNetworkGatewayPolicyGroup resource which represents the available VirtualNetworkGatewayPolicyGroup for the gateway.
 * @property vpnClientConfiguration The reference to the VpnClientConfiguration resource which represents the P2S VpnClient configurations.
 * @property vpnGatewayGeneration The generation for this VirtualNetworkGateway. Must be None if gatewayType is not VPN.
 * @property vpnType The type of this virtual network gateway.
 */
public data class VirtualNetworkGatewayResponse(
    public val activeActive: Boolean? = null,
    public val adminState: String? = null,
    public val allowRemoteVnetTraffic: Boolean? = null,
    public val allowVirtualWanTraffic: Boolean? = null,
    public val bgpSettings: BgpSettingsResponse? = null,
    public val customRoutes: AddressSpaceResponse? = null,
    public val disableIPSecReplayProtection: Boolean? = null,
    public val enableBgp: Boolean? = null,
    public val enableBgpRouteTranslationForNat: Boolean? = null,
    public val enableDnsForwarding: Boolean? = null,
    public val enablePrivateIpAddress: Boolean? = null,
    public val etag: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val gatewayDefaultSite: SubResourceResponse? = null,
    public val gatewayType: String? = null,
    public val id: String? = null,
    public val inboundDnsForwardingEndpoint: String,
    public val ipConfigurations: List<VirtualNetworkGatewayIPConfigurationResponse>? = null,
    public val location: String? = null,
    public val name: String,
    public val natRules: List<VirtualNetworkGatewayNatRuleResponse>? = null,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val sku: VirtualNetworkGatewaySkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val vNetExtendedLocationResourceId: String? = null,
    public val virtualNetworkGatewayPolicyGroups: List<VirtualNetworkGatewayPolicyGroupResponse>? =
        null,
    public val vpnClientConfiguration: VpnClientConfigurationResponse? = null,
    public val vpnGatewayGeneration: String? = null,
    public val vpnType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualNetworkGatewayResponse):
            VirtualNetworkGatewayResponse = VirtualNetworkGatewayResponse(
            activeActive = javaType.activeActive().map({ args0 -> args0 }).orElse(null),
            adminState = javaType.adminState().map({ args0 -> args0 }).orElse(null),
            allowRemoteVnetTraffic = javaType.allowRemoteVnetTraffic().map({ args0 -> args0 }).orElse(null),
            allowVirtualWanTraffic = javaType.allowVirtualWanTraffic().map({ args0 -> args0 }).orElse(null),
            bgpSettings = javaType.bgpSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BgpSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            customRoutes = javaType.customRoutes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            disableIPSecReplayProtection = javaType.disableIPSecReplayProtection().map({ args0 ->
                args0
            }).orElse(null),
            enableBgp = javaType.enableBgp().map({ args0 -> args0 }).orElse(null),
            enableBgpRouteTranslationForNat = javaType.enableBgpRouteTranslationForNat().map({ args0 ->
                args0
            }).orElse(null),
            enableDnsForwarding = javaType.enableDnsForwarding().map({ args0 -> args0 }).orElse(null),
            enablePrivateIpAddress = javaType.enablePrivateIpAddress().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            gatewayDefaultSite = javaType.gatewayDefaultSite().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            gatewayType = javaType.gatewayType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            inboundDnsForwardingEndpoint = javaType.inboundDnsForwardingEndpoint(),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkGatewayIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            natRules = javaType.natRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkGatewayNatRuleResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkGatewaySkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            vNetExtendedLocationResourceId = javaType.vNetExtendedLocationResourceId().map({ args0 ->
                args0
            }).orElse(null),
            virtualNetworkGatewayPolicyGroups = javaType.virtualNetworkGatewayPolicyGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkGatewayPolicyGroupResponse.Companion.toKotlin(args0)
                })
            }),
            vpnClientConfiguration = javaType.vpnClientConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnClientConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vpnGatewayGeneration = javaType.vpnGatewayGeneration().map({ args0 -> args0 }).orElse(null),
            vpnType = javaType.vpnType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
