@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Peerings in a virtual network resource.
 * @property allowForwardedTraffic Whether the forwarded traffic from the VMs in the local virtual network will be allowed/disallowed in remote virtual network.
 * @property allowGatewayTransit If gateway links can be used in remote virtual networking to link to this virtual network.
 * @property allowVirtualNetworkAccess Whether the VMs in the local virtual network space would be able to access the VMs in remote virtual network space.
 * @property doNotVerifyRemoteGateways If we need to verify the provisioning state of the remote gateway.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property peeringState The status of the virtual network peering.
 * @property peeringSyncLevel The peering sync status of the virtual network peering.
 * @property provisioningState The provisioning state of the virtual network peering resource.
 * @property remoteAddressSpace The reference to the address space peered with the remote virtual network.
 * @property remoteBgpCommunities The reference to the remote virtual network's Bgp Communities.
 * @property remoteVirtualNetwork The reference to the remote virtual network. The remote virtual network can be in the same or different region (preview). See here to register for the preview and learn more (https://docs.microsoft.com/en-us/azure/virtual-network/virtual-network-create-peering).
 * @property remoteVirtualNetworkAddressSpace The reference to the current address space of the remote virtual network.
 * @property remoteVirtualNetworkEncryption The reference to the remote virtual network's encryption
 * @property resourceGuid The resourceGuid property of the Virtual Network peering resource.
 * @property type Resource type.
 * @property useRemoteGateways If remote gateways can be used on this virtual network. If the flag is set to true, and allowGatewayTransit on remote peering is also true, virtual network will use gateways of remote virtual network for transit. Only one peering can have this flag set to true. This flag cannot be set if virtual network already has a gateway.
 */
public data class VirtualNetworkPeeringResponse(
    public val allowForwardedTraffic: Boolean? = null,
    public val allowGatewayTransit: Boolean? = null,
    public val allowVirtualNetworkAccess: Boolean? = null,
    public val doNotVerifyRemoteGateways: Boolean? = null,
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val peeringState: String? = null,
    public val peeringSyncLevel: String? = null,
    public val provisioningState: String,
    public val remoteAddressSpace: AddressSpaceResponse? = null,
    public val remoteBgpCommunities: VirtualNetworkBgpCommunitiesResponse? = null,
    public val remoteVirtualNetwork: SubResourceResponse? = null,
    public val remoteVirtualNetworkAddressSpace: AddressSpaceResponse? = null,
    public val remoteVirtualNetworkEncryption: VirtualNetworkEncryptionResponse,
    public val resourceGuid: String,
    public val type: String? = null,
    public val useRemoteGateways: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VirtualNetworkPeeringResponse):
            VirtualNetworkPeeringResponse = VirtualNetworkPeeringResponse(
            allowForwardedTraffic = javaType.allowForwardedTraffic().map({ args0 -> args0 }).orElse(null),
            allowGatewayTransit = javaType.allowGatewayTransit().map({ args0 -> args0 }).orElse(null),
            allowVirtualNetworkAccess = javaType.allowVirtualNetworkAccess().map({ args0 ->
                args0
            }).orElse(null),
            doNotVerifyRemoteGateways = javaType.doNotVerifyRemoteGateways().map({ args0 ->
                args0
            }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            peeringState = javaType.peeringState().map({ args0 -> args0 }).orElse(null),
            peeringSyncLevel = javaType.peeringSyncLevel().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            remoteAddressSpace = javaType.remoteAddressSpace().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            remoteBgpCommunities = javaType.remoteBgpCommunities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkBgpCommunitiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            remoteVirtualNetwork = javaType.remoteVirtualNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            remoteVirtualNetworkAddressSpace = javaType.remoteVirtualNetworkAddressSpace().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            remoteVirtualNetworkEncryption = javaType.remoteVirtualNetworkEncryption().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkEncryptionResponse.Companion.toKotlin(args0)
            }),
            resourceGuid = javaType.resourceGuid(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            useRemoteGateways = javaType.useRemoteGateways().map({ args0 -> args0 }).orElse(null),
        )
    }
}
