@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * VpnSiteLink Resource.
 * @property bgpProperties The set of bgp properties.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property fqdn FQDN of vpn-site-link.
 * @property id Resource ID.
 * @property ipAddress The ip-address for the vpn-site-link.
 * @property linkProperties The link provider properties.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the VPN site link resource.
 * @property type Resource type.
 */
public data class VpnSiteLinkResponse(
    public val bgpProperties: VpnLinkBgpSettingsResponse? = null,
    public val etag: String,
    public val fqdn: String? = null,
    public val id: String? = null,
    public val ipAddress: String? = null,
    public val linkProperties: VpnLinkProviderPropertiesResponse? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.VpnSiteLinkResponse):
            VpnSiteLinkResponse = VpnSiteLinkResponse(
            bgpProperties = javaType.bgpProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnLinkBgpSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            linkProperties = javaType.linkProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VpnLinkProviderPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
