@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin

import com.pulumi.azurenative.networkanalytics.DataProductArgs.builder
import com.pulumi.azurenative.networkanalytics.kotlin.enums.ControlState
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.DataProductNetworkAclsArgs
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.DataProductNetworkAclsArgsBuilder
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.EncryptionKeyDetailsArgs
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.EncryptionKeyDetailsArgsBuilder
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.ManagedResourceGroupConfigurationArgs
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.ManagedResourceGroupConfigurationArgsBuilder
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.ManagedServiceIdentityArgs
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.ManagedServiceIdentityArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The data product resource.
 * Azure REST API version: 2023-11-15.
 * ## Example Usage
 * ### DataProducts_Create_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataProduct = new AzureNative.NetworkAnalytics.DataProduct("dataProduct", new()
 *     {
 *         DataProductName = "dataproduct01",
 *         Location = "eastus",
 *         MajorVersion = "1.0.0",
 *         Product = "MCC",
 *         Publisher = "Microsoft",
 *         ResourceGroupName = "aoiresourceGroupName",
 *         Tags =
 *         {
 *             { "userSpecifiedKeyName", "userSpecifiedKeyValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkanalytics.NewDataProduct(ctx, "dataProduct", &networkanalytics.DataProductArgs{
 * 			DataProductName:   pulumi.String("dataproduct01"),
 * 			Location:          pulumi.String("eastus"),
 * 			MajorVersion:      pulumi.String("1.0.0"),
 * 			Product:           pulumi.String("MCC"),
 * 			Publisher:         pulumi.String("Microsoft"),
 * 			ResourceGroupName: pulumi.String("aoiresourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"userSpecifiedKeyName": pulumi.String("userSpecifiedKeyValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkanalytics.DataProduct;
 * import com.pulumi.azurenative.networkanalytics.DataProductArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataProduct = new DataProduct("dataProduct", DataProductArgs.builder()
 *             .dataProductName("dataproduct01")
 *             .location("eastus")
 *             .majorVersion("1.0.0")
 *             .product("MCC")
 *             .publisher("Microsoft")
 *             .resourceGroupName("aoiresourceGroupName")
 *             .tags(Map.of("userSpecifiedKeyName", "userSpecifiedKeyValue"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkanalytics:DataProduct dataproduct01 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}
 * ```
 * @property currentMinorVersion Current configured minor version of the data product resource.
 * @property customerEncryptionKey Customer managed encryption key details for data product.
 * @property customerManagedKeyEncryptionEnabled Flag to enable customer managed key encryption for data product.
 * @property dataProductName The data product resource name
 * @property identity The managed service identities assigned to this resource.
 * @property location The geo-location where the resource lives
 * @property majorVersion Major version of data product.
 * @property managedResourceGroupConfiguration Managed resource group configuration.
 * @property networkacls Network rule set for data product.
 * @property owners List of name or email associated with data product resource deployment.
 * @property privateLinksEnabled Flag to enable or disable private link for data product resource.
 * @property product Product name of data product.
 * @property publicNetworkAccess Flag to enable or disable public access of data product resource.
 * @property publisher Data product publisher name.
 * @property purviewAccount Purview account url for data product to connect to.
 * @property purviewCollection Purview collection url for data product to connect to.
 * @property redundancy Flag to enable or disable redundancy for data product.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class DataProductArgs(
    public val currentMinorVersion: Output<String>? = null,
    public val customerEncryptionKey: Output<EncryptionKeyDetailsArgs>? = null,
    public val customerManagedKeyEncryptionEnabled: Output<Either<String, ControlState>>? = null,
    public val dataProductName: Output<String>? = null,
    public val identity: Output<ManagedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val majorVersion: Output<String>? = null,
    public val managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null,
    public val networkacls: Output<DataProductNetworkAclsArgs>? = null,
    public val owners: Output<List<String>>? = null,
    public val privateLinksEnabled: Output<Either<String, ControlState>>? = null,
    public val product: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, ControlState>>? = null,
    public val publisher: Output<String>? = null,
    public val purviewAccount: Output<String>? = null,
    public val purviewCollection: Output<String>? = null,
    public val redundancy: Output<Either<String, ControlState>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkanalytics.DataProductArgs> {
    override fun toJava(): com.pulumi.azurenative.networkanalytics.DataProductArgs =
        com.pulumi.azurenative.networkanalytics.DataProductArgs.builder()
            .currentMinorVersion(currentMinorVersion?.applyValue({ args0 -> args0 }))
            .customerEncryptionKey(
                customerEncryptionKey?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .customerManagedKeyEncryptionEnabled(
                customerManagedKeyEncryptionEnabled?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .dataProductName(dataProductName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .majorVersion(majorVersion?.applyValue({ args0 -> args0 }))
            .managedResourceGroupConfiguration(
                managedResourceGroupConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .networkacls(networkacls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .owners(owners?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .privateLinksEnabled(
                privateLinksEnabled?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .product(product?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publisher(publisher?.applyValue({ args0 -> args0 }))
            .purviewAccount(purviewAccount?.applyValue({ args0 -> args0 }))
            .purviewCollection(purviewCollection?.applyValue({ args0 -> args0 }))
            .redundancy(
                redundancy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DataProductArgs].
 */
@PulumiTagMarker
public class DataProductArgsBuilder internal constructor() {
    private var currentMinorVersion: Output<String>? = null

    private var customerEncryptionKey: Output<EncryptionKeyDetailsArgs>? = null

    private var customerManagedKeyEncryptionEnabled: Output<Either<String, ControlState>>? = null

    private var dataProductName: Output<String>? = null

    private var identity: Output<ManagedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var majorVersion: Output<String>? = null

    private var managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationArgs>? =
        null

    private var networkacls: Output<DataProductNetworkAclsArgs>? = null

    private var owners: Output<List<String>>? = null

    private var privateLinksEnabled: Output<Either<String, ControlState>>? = null

    private var product: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, ControlState>>? = null

    private var publisher: Output<String>? = null

    private var purviewAccount: Output<String>? = null

    private var purviewCollection: Output<String>? = null

    private var redundancy: Output<Either<String, ControlState>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Current configured minor version of the data product resource.
     */
    @JvmName("gghgjdjiotqxnjyu")
    public suspend fun currentMinorVersion(`value`: Output<String>) {
        this.currentMinorVersion = value
    }

    /**
     * @param value Customer managed encryption key details for data product.
     */
    @JvmName("sppbownlglbopifl")
    public suspend fun customerEncryptionKey(`value`: Output<EncryptionKeyDetailsArgs>) {
        this.customerEncryptionKey = value
    }

    /**
     * @param value Flag to enable customer managed key encryption for data product.
     */
    @JvmName("fosimlwsdvljnuqb")
    public suspend
    fun customerManagedKeyEncryptionEnabled(`value`: Output<Either<String, ControlState>>) {
        this.customerManagedKeyEncryptionEnabled = value
    }

    /**
     * @param value The data product resource name
     */
    @JvmName("pljfixmyptsaocmj")
    public suspend fun dataProductName(`value`: Output<String>) {
        this.dataProductName = value
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("fgslhdtvtiyuuasb")
    public suspend fun identity(`value`: Output<ManagedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ximijopyoehtepfs")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Major version of data product.
     */
    @JvmName("olyohbtutpxovqoq")
    public suspend fun majorVersion(`value`: Output<String>) {
        this.majorVersion = value
    }

    /**
     * @param value Managed resource group configuration.
     */
    @JvmName("scctqsphusefjhve")
    public suspend
    fun managedResourceGroupConfiguration(`value`: Output<ManagedResourceGroupConfigurationArgs>) {
        this.managedResourceGroupConfiguration = value
    }

    /**
     * @param value Network rule set for data product.
     */
    @JvmName("etcrcgtnexfcrikv")
    public suspend fun networkacls(`value`: Output<DataProductNetworkAclsArgs>) {
        this.networkacls = value
    }

    /**
     * @param value List of name or email associated with data product resource deployment.
     */
    @JvmName("fyggkwjdrkppwhhk")
    public suspend fun owners(`value`: Output<List<String>>) {
        this.owners = value
    }

    @JvmName("ulvogkxuubydjsge")
    public suspend fun owners(vararg values: Output<String>) {
        this.owners = Output.all(values.asList())
    }

    /**
     * @param values List of name or email associated with data product resource deployment.
     */
    @JvmName("xprypgrutmdgrgvc")
    public suspend fun owners(values: List<Output<String>>) {
        this.owners = Output.all(values)
    }

    /**
     * @param value Flag to enable or disable private link for data product resource.
     */
    @JvmName("timxjyapwxygksjv")
    public suspend fun privateLinksEnabled(`value`: Output<Either<String, ControlState>>) {
        this.privateLinksEnabled = value
    }

    /**
     * @param value Product name of data product.
     */
    @JvmName("bqnqnlcxehdnhyjx")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value Flag to enable or disable public access of data product resource.
     */
    @JvmName("ccgdecfanipegjfp")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, ControlState>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Data product publisher name.
     */
    @JvmName("pewkushlorjfydyw")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value Purview account url for data product to connect to.
     */
    @JvmName("dfhhjrtncvpxqdfk")
    public suspend fun purviewAccount(`value`: Output<String>) {
        this.purviewAccount = value
    }

    /**
     * @param value Purview collection url for data product to connect to.
     */
    @JvmName("aoktruigmhwkebsa")
    public suspend fun purviewCollection(`value`: Output<String>) {
        this.purviewCollection = value
    }

    /**
     * @param value Flag to enable or disable redundancy for data product.
     */
    @JvmName("swntdbsnjkrljkgt")
    public suspend fun redundancy(`value`: Output<Either<String, ControlState>>) {
        this.redundancy = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xjnpkarqscdixdai")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("gjhkjfumqvwabdbg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Current configured minor version of the data product resource.
     */
    @JvmName("rtrxjijhoggnkipn")
    public suspend fun currentMinorVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.currentMinorVersion = mapped
    }

    /**
     * @param value Customer managed encryption key details for data product.
     */
    @JvmName("ajrsedjmuyguispv")
    public suspend fun customerEncryptionKey(`value`: EncryptionKeyDetailsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerEncryptionKey = mapped
    }

    /**
     * @param argument Customer managed encryption key details for data product.
     */
    @JvmName("mhupvoxoiylspqcx")
    public suspend
    fun customerEncryptionKey(argument: suspend EncryptionKeyDetailsArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionKeyDetailsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.customerEncryptionKey = mapped
    }

    /**
     * @param value Flag to enable customer managed key encryption for data product.
     */
    @JvmName("qjnjtbtgjgwtcuxb")
    public suspend fun customerManagedKeyEncryptionEnabled(`value`: Either<String, ControlState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerManagedKeyEncryptionEnabled = mapped
    }

    /**
     * @param value Flag to enable customer managed key encryption for data product.
     */
    @JvmName("vyoqcdxhvoaoojds")
    public fun customerManagedKeyEncryptionEnabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ControlState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerManagedKeyEncryptionEnabled = mapped
    }

    /**
     * @param value Flag to enable customer managed key encryption for data product.
     */
    @JvmName("itldptbnerviivld")
    public fun customerManagedKeyEncryptionEnabled(`value`: ControlState) {
        val toBeMapped = Either.ofRight<String, ControlState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customerManagedKeyEncryptionEnabled = mapped
    }

    /**
     * @param value The data product resource name
     */
    @JvmName("gwqeioywaryqspcy")
    public suspend fun dataProductName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataProductName = mapped
    }

    /**
     * @param value The managed service identities assigned to this resource.
     */
    @JvmName("xxgxonvispiblcun")
    public suspend fun identity(`value`: ManagedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed service identities assigned to this resource.
     */
    @JvmName("pkvlnwicnhitantp")
    public suspend fun identity(argument: suspend ManagedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ohmubbjueouveyew")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Major version of data product.
     */
    @JvmName("gcdhkoiuaqxsnyvm")
    public suspend fun majorVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.majorVersion = mapped
    }

    /**
     * @param value Managed resource group configuration.
     */
    @JvmName("xkjygfdiwspvhiwt")
    public suspend
    fun managedResourceGroupConfiguration(`value`: ManagedResourceGroupConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param argument Managed resource group configuration.
     */
    @JvmName("qpjcbblvbrlpkffw")
    public suspend
    fun managedResourceGroupConfiguration(argument: suspend ManagedResourceGroupConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedResourceGroupConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.managedResourceGroupConfiguration = mapped
    }

    /**
     * @param value Network rule set for data product.
     */
    @JvmName("tlscxmttlchbgcdk")
    public suspend fun networkacls(`value`: DataProductNetworkAclsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkacls = mapped
    }

    /**
     * @param argument Network rule set for data product.
     */
    @JvmName("akrcuhyedxixtfpv")
    public suspend fun networkacls(argument: suspend DataProductNetworkAclsArgsBuilder.() -> Unit) {
        val toBeMapped = DataProductNetworkAclsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkacls = mapped
    }

    /**
     * @param value List of name or email associated with data product resource deployment.
     */
    @JvmName("oykofqcytyraiyvy")
    public suspend fun owners(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owners = mapped
    }

    /**
     * @param values List of name or email associated with data product resource deployment.
     */
    @JvmName("yjwvhlqwbqlsahlv")
    public suspend fun owners(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.owners = mapped
    }

    /**
     * @param value Flag to enable or disable private link for data product resource.
     */
    @JvmName("oqbhdwxxbwqmyust")
    public suspend fun privateLinksEnabled(`value`: Either<String, ControlState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinksEnabled = mapped
    }

    /**
     * @param value Flag to enable or disable private link for data product resource.
     */
    @JvmName("fjkbjctldonffllh")
    public fun privateLinksEnabled(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ControlState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinksEnabled = mapped
    }

    /**
     * @param value Flag to enable or disable private link for data product resource.
     */
    @JvmName("qovgfpeywbvylcyj")
    public fun privateLinksEnabled(`value`: ControlState) {
        val toBeMapped = Either.ofRight<String, ControlState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinksEnabled = mapped
    }

    /**
     * @param value Product name of data product.
     */
    @JvmName("fdpiabbmqjvlxjvy")
    public suspend fun product(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value Flag to enable or disable public access of data product resource.
     */
    @JvmName("trlowawbvieudrvk")
    public suspend fun publicNetworkAccess(`value`: Either<String, ControlState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Flag to enable or disable public access of data product resource.
     */
    @JvmName("mcxxymxkiyevxoct")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ControlState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Flag to enable or disable public access of data product resource.
     */
    @JvmName("liqxuqilqgjhjadi")
    public fun publicNetworkAccess(`value`: ControlState) {
        val toBeMapped = Either.ofRight<String, ControlState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Data product publisher name.
     */
    @JvmName("vugkodeyeiwdbtnf")
    public suspend fun publisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value Purview account url for data product to connect to.
     */
    @JvmName("iaclffvtocekdjum")
    public suspend fun purviewAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purviewAccount = mapped
    }

    /**
     * @param value Purview collection url for data product to connect to.
     */
    @JvmName("ivilntgswiauyauf")
    public suspend fun purviewCollection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.purviewCollection = mapped
    }

    /**
     * @param value Flag to enable or disable redundancy for data product.
     */
    @JvmName("nmpmxrvnqoeftikq")
    public suspend fun redundancy(`value`: Either<String, ControlState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redundancy = mapped
    }

    /**
     * @param value Flag to enable or disable redundancy for data product.
     */
    @JvmName("ryhmmttejuqtqgys")
    public fun redundancy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ControlState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redundancy = mapped
    }

    /**
     * @param value Flag to enable or disable redundancy for data product.
     */
    @JvmName("nxbeotyuovilfjon")
    public fun redundancy(`value`: ControlState) {
        val toBeMapped = Either.ofRight<String, ControlState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redundancy = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dokaofivfjehfinc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jvuwpvjxgmnwlmbg")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("nsmmqdqtetstokut")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataProductArgs = DataProductArgs(
        currentMinorVersion = currentMinorVersion,
        customerEncryptionKey = customerEncryptionKey,
        customerManagedKeyEncryptionEnabled = customerManagedKeyEncryptionEnabled,
        dataProductName = dataProductName,
        identity = identity,
        location = location,
        majorVersion = majorVersion,
        managedResourceGroupConfiguration = managedResourceGroupConfiguration,
        networkacls = networkacls,
        owners = owners,
        privateLinksEnabled = privateLinksEnabled,
        product = product,
        publicNetworkAccess = publicNetworkAccess,
        publisher = publisher,
        purviewAccount = purviewAccount,
        purviewCollection = purviewCollection,
        redundancy = redundancy,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
