@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin

import com.pulumi.azurenative.networkanalytics.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DataType].
 */
@PulumiTagMarker
public class DataTypeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataTypeArgs = DataTypeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataTypeArgsBuilder.() -> Unit) {
        val builder = DataTypeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataType {
        val builtJavaResource =
            com.pulumi.azurenative.networkanalytics.DataType(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataType(builtJavaResource)
    }
}

/**
 * The data type resource.
 * Azure REST API version: 2023-11-15.
 * ## Example Usage
 * ### DataTypes_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataType = new AzureNative.NetworkAnalytics.DataType("dataType", new()
 *     {
 *         DataProductName = "dataproduct01",
 *         DataTypeName = "datatypename",
 *         DatabaseCacheRetention = 23,
 *         DatabaseRetention = 6,
 *         ResourceGroupName = "aoiresourceGroupName",
 *         State = "STARTED",
 *         StorageOutputRetention = 27,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkanalytics.NewDataType(ctx, "dataType", &networkanalytics.DataTypeArgs{
 * 			DataProductName:        pulumi.String("dataproduct01"),
 * 			DataTypeName:           pulumi.String("datatypename"),
 * 			DatabaseCacheRetention: pulumi.Int(23),
 * 			DatabaseRetention:      pulumi.Int(6),
 * 			ResourceGroupName:      pulumi.String("aoiresourceGroupName"),
 * 			State:                  pulumi.String("STARTED"),
 * 			StorageOutputRetention: pulumi.Int(27),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkanalytics.DataType;
 * import com.pulumi.azurenative.networkanalytics.DataTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataType = new DataType("dataType", DataTypeArgs.builder()
 *             .dataProductName("dataproduct01")
 *             .dataTypeName("datatypename")
 *             .databaseCacheRetention(23)
 *             .databaseRetention(6)
 *             .resourceGroupName("aoiresourceGroupName")
 *             .state("STARTED")
 *             .storageOutputRetention(27)
 *             .build());
 *     }
 * }
 * ```
 * ### DataTypes_Create_MaximumSet_Gen - generated by [MinimumSet] rule_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataType = new AzureNative.NetworkAnalytics.DataType("dataType", new()
 *     {
 *         DataProductName = "dataproduct01",
 *         DataTypeName = "datatypename",
 *         ResourceGroupName = "aoiresourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkanalytics/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkanalytics.NewDataType(ctx, "dataType", &networkanalytics.DataTypeArgs{
 * 			DataProductName:   pulumi.String("dataproduct01"),
 * 			DataTypeName:      pulumi.String("datatypename"),
 * 			ResourceGroupName: pulumi.String("aoiresourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkanalytics.DataType;
 * import com.pulumi.azurenative.networkanalytics.DataTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataType = new DataType("dataType", DataTypeArgs.builder()
 *             .dataProductName("dataproduct01")
 *             .dataTypeName("datatypename")
 *             .resourceGroupName("aoiresourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkanalytics:DataType datatypeName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/dataTypes/{dataTypeName}
 * ```
 */
public class DataType internal constructor(
    override val javaResource: com.pulumi.azurenative.networkanalytics.DataType,
) : KotlinCustomResource(javaResource, DataTypeMapper) {
    /**
     * Field for database cache retention in days.
     */
    public val databaseCacheRetention: Output<Int>?
        get() = javaResource.databaseCacheRetention().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Field for database data retention in days.
     */
    public val databaseRetention: Output<Int>?
        get() = javaResource.databaseRetention().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Latest provisioning state  of data product.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * State of data type.
     */
    public val state: Output<String>?
        get() = javaResource.state().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Reason for the state of data type.
     */
    public val stateReason: Output<String>
        get() = javaResource.stateReason().applyValue({ args0 -> args0 })

    /**
     * Field for storage output retention in days.
     */
    public val storageOutputRetention: Output<Int>?
        get() = javaResource.storageOutputRetention().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Url for data visualization.
     */
    public val visualizationUrl: Output<String>
        get() = javaResource.visualizationUrl().applyValue({ args0 -> args0 })
}

public object DataTypeMapper : ResourceMapper<DataType> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkanalytics.DataType::class == javaResource::class

    override fun map(javaResource: Resource): DataType = DataType(
        javaResource as
            com.pulumi.azurenative.networkanalytics.DataType,
    )
}

/**
 * @see [DataType].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataType].
 */
public suspend fun dataType(name: String, block: suspend DataTypeResourceBuilder.() -> Unit):
    DataType {
    val builder = DataTypeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataType].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataType(name: String): DataType {
    val builder = DataTypeResourceBuilder()
    builder.name(name)
    return builder.build()
}
