@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin

import com.pulumi.azurenative.networkanalytics.NetworkanalyticsFunctions.getDataProductPlain
import com.pulumi.azurenative.networkanalytics.NetworkanalyticsFunctions.getDataTypePlain
import com.pulumi.azurenative.networkanalytics.NetworkanalyticsFunctions.listDataProductRolesAssignmentsPlain
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.GetDataProductPlainArgs
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.GetDataProductPlainArgsBuilder
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.GetDataTypePlainArgs
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.GetDataTypePlainArgsBuilder
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.ListDataProductRolesAssignmentsPlainArgs
import com.pulumi.azurenative.networkanalytics.kotlin.inputs.ListDataProductRolesAssignmentsPlainArgsBuilder
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.GetDataProductResult
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.GetDataTypeResult
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.ListDataProductRolesAssignmentsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.GetDataProductResult.Companion.toKotlin as getDataProductResultToKotlin
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.GetDataTypeResult.Companion.toKotlin as getDataTypeResultToKotlin
import com.pulumi.azurenative.networkanalytics.kotlin.outputs.ListDataProductRolesAssignmentsResult.Companion.toKotlin as listDataProductRolesAssignmentsResultToKotlin

public object NetworkanalyticsFunctions {
    /**
     * Retrieve data product resource.
     * Azure REST API version: 2023-11-15.
     * @param argument null
     * @return The data product resource.
     */
    public suspend fun getDataProduct(argument: GetDataProductPlainArgs): GetDataProductResult =
        getDataProductResultToKotlin(getDataProductPlain(argument.toJava()).await())

    /**
     * @see [getDataProduct].
     * @param dataProductName The data product resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The data product resource.
     */
    public suspend fun getDataProduct(dataProductName: String, resourceGroupName: String):
        GetDataProductResult {
        val argument = GetDataProductPlainArgs(
            dataProductName = dataProductName,
            resourceGroupName = resourceGroupName,
        )
        return getDataProductResultToKotlin(getDataProductPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataProduct].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkanalytics&#46;kotlin&#46;inputs&#46;GetDataProductPlainArgs].
     * @return The data product resource.
     */
    public suspend fun getDataProduct(argument: suspend GetDataProductPlainArgsBuilder.() -> Unit):
        GetDataProductResult {
        val builder = GetDataProductPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataProductResultToKotlin(getDataProductPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve data type resource.
     * Azure REST API version: 2023-11-15.
     * @param argument null
     * @return The data type resource.
     */
    public suspend fun getDataType(argument: GetDataTypePlainArgs): GetDataTypeResult =
        getDataTypeResultToKotlin(getDataTypePlain(argument.toJava()).await())

    /**
     * @see [getDataType].
     * @param dataProductName The data product resource name
     * @param dataTypeName The data type name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The data type resource.
     */
    public suspend fun getDataType(
        dataProductName: String,
        dataTypeName: String,
        resourceGroupName: String,
    ): GetDataTypeResult {
        val argument = GetDataTypePlainArgs(
            dataProductName = dataProductName,
            dataTypeName = dataTypeName,
            resourceGroupName = resourceGroupName,
        )
        return getDataTypeResultToKotlin(getDataTypePlain(argument.toJava()).await())
    }

    /**
     * @see [getDataType].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkanalytics&#46;kotlin&#46;inputs&#46;GetDataTypePlainArgs].
     * @return The data type resource.
     */
    public suspend fun getDataType(argument: suspend GetDataTypePlainArgsBuilder.() -> Unit):
        GetDataTypeResult {
        val builder = GetDataTypePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataTypeResultToKotlin(getDataTypePlain(builtArgument.toJava()).await())
    }

    /**
     * List user roles associated with the data product.
     * Azure REST API version: 2023-11-15.
     * @param argument null
     * @return list role assignments.
     */
    public suspend
    fun listDataProductRolesAssignments(argument: ListDataProductRolesAssignmentsPlainArgs):
        ListDataProductRolesAssignmentsResult =
        listDataProductRolesAssignmentsResultToKotlin(listDataProductRolesAssignmentsPlain(argument.toJava()).await())

    /**
     * @see [listDataProductRolesAssignments].
     * @param dataProductName The data product resource name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return list role assignments.
     */
    public suspend fun listDataProductRolesAssignments(
        dataProductName: String,
        resourceGroupName: String,
    ): ListDataProductRolesAssignmentsResult {
        val argument = ListDataProductRolesAssignmentsPlainArgs(
            dataProductName = dataProductName,
            resourceGroupName = resourceGroupName,
        )
        return listDataProductRolesAssignmentsResultToKotlin(listDataProductRolesAssignmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [listDataProductRolesAssignments].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkanalytics&#46;kotlin&#46;inputs&#46;ListDataProductRolesAssignmentsPlainArgs].
     * @return list role assignments.
     */
    public suspend
    fun listDataProductRolesAssignments(argument: suspend ListDataProductRolesAssignmentsPlainArgsBuilder.() -> Unit):
        ListDataProductRolesAssignmentsResult {
        val builder = ListDataProductRolesAssignmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listDataProductRolesAssignmentsResultToKotlin(listDataProductRolesAssignmentsPlain(builtArgument.toJava()).await())
    }
}
