@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.inputs

import com.pulumi.azurenative.networkanalytics.inputs.EncryptionKeyDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Encryption key details.
 * @property keyName The name of the key vault key.
 * @property keyVaultUri The Uri of the key vault.
 * @property keyVersion The version of the key vault key.
 */
public data class EncryptionKeyDetailsArgs(
    public val keyName: Output<String>,
    public val keyVaultUri: Output<String>,
    public val keyVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.networkanalytics.inputs.EncryptionKeyDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.networkanalytics.inputs.EncryptionKeyDetailsArgs =
        com.pulumi.azurenative.networkanalytics.inputs.EncryptionKeyDetailsArgs.builder()
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionKeyDetailsArgs].
 */
@PulumiTagMarker
public class EncryptionKeyDetailsArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value The name of the key vault key.
     */
    @JvmName("yygyhwntmhjhvdcb")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The Uri of the key vault.
     */
    @JvmName("wmtchldkfupholon")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The version of the key vault key.
     */
    @JvmName("sjshtjpqkhcoddjk")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value The name of the key vault key.
     */
    @JvmName("ggysabpxvoaawahc")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The Uri of the key vault.
     */
    @JvmName("ytvgxconmwguwuyk")
    public suspend fun keyVaultUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The version of the key vault key.
     */
    @JvmName("xoafpttshyubhwvp")
    public suspend fun keyVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): EncryptionKeyDetailsArgs = EncryptionKeyDetailsArgs(
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        keyVaultUri = keyVaultUri ?: throw PulumiNullFieldException("keyVaultUri"),
        keyVersion = keyVersion ?: throw PulumiNullFieldException("keyVersion"),
    )
}
