@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.inputs

import com.pulumi.azurenative.networkanalytics.inputs.GetDataProductPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataProductName The data product resource name
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDataProductPlainArgs(
    public val dataProductName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkanalytics.inputs.GetDataProductPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkanalytics.inputs.GetDataProductPlainArgs =
        com.pulumi.azurenative.networkanalytics.inputs.GetDataProductPlainArgs.builder()
            .dataProductName(dataProductName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataProductPlainArgs].
 */
@PulumiTagMarker
public class GetDataProductPlainArgsBuilder internal constructor() {
    private var dataProductName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The data product resource name
     */
    @JvmName("lexvwhxxyhulajsq")
    public suspend fun dataProductName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataProductName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wvsbyiqmjnaurswv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataProductPlainArgs = GetDataProductPlainArgs(
        dataProductName = dataProductName ?: throw PulumiNullFieldException("dataProductName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
