@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkanalytics.kotlin.inputs

import com.pulumi.azurenative.networkanalytics.inputs.IPRulesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IP rule with specific IP or IP range in CIDR format.
 * @property action The action of virtual network rule.
 * @property value IP Rules Value
 */
public data class IPRulesArgs(
    public val action: Output<String>,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkanalytics.inputs.IPRulesArgs> {
    override fun toJava(): com.pulumi.azurenative.networkanalytics.inputs.IPRulesArgs =
        com.pulumi.azurenative.networkanalytics.inputs.IPRulesArgs.builder()
            .action(action.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPRulesArgs].
 */
@PulumiTagMarker
public class IPRulesArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The action of virtual network rule.
     */
    @JvmName("lhlubincmbmhnxvj")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value IP Rules Value
     */
    @JvmName("ikecahrjxnpqdabt")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The action of virtual network rule.
     */
    @JvmName("wsfmtcegvmtugwbm")
    public suspend fun action(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value IP Rules Value
     */
    @JvmName("gqmedgchnlwcgcrr")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): IPRulesArgs = IPRulesArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        `value` = `value`,
    )
}
