@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.BareMetalMachineKeySetArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.BareMetalMachineKeySetPrivilegeLevel
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.KeySetUserArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.KeySetUserArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update bare metal machine key set of cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var bareMetalMachineKeySet = new AzureNative.NetworkCloud.BareMetalMachineKeySet("bareMetalMachineKeySet", new()
 *     {
 *         AzureGroupId = "f110271b-XXXX-4163-9b99-214d91660f0e",
 *         BareMetalMachineKeySetName = "bareMetalMachineKeySetName",
 *         ClusterName = "clusterName",
 *         Expiration = "2022-12-31T23:59:59.008Z",
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         JumpHostsAllowed = new[]
 *         {
 *             "192.0.2.1",
 *             "192.0.2.5",
 *         },
 *         Location = "location",
 *         OsGroupName = "standardAccessGroup",
 *         PrivilegeLevel = "Standard",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         UserList = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.KeySetUserArgs
 *             {
 *                 AzureUserName = "userABC",
 *                 Description = "Needs access for troubleshooting as a part of the support team",
 *                 SshPublicKey = new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                 {
 *                     KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                 },
 *             },
 *             new AzureNative.NetworkCloud.Inputs.KeySetUserArgs
 *             {
 *                 AzureUserName = "userXYZ",
 *                 Description = "Needs access for troubleshooting as a part of the support team",
 *                 SshPublicKey = new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                 {
 *                     KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewBareMetalMachineKeySet(ctx, "bareMetalMachineKeySet", &networkcloud.BareMetalMachineKeySetArgs{
 * 			AzureGroupId:               pulumi.String("f110271b-XXXX-4163-9b99-214d91660f0e"),
 * 			BareMetalMachineKeySetName: pulumi.String("bareMetalMachineKeySetName"),
 * 			ClusterName:                pulumi.String("clusterName"),
 * 			Expiration:                 pulumi.String("2022-12-31T23:59:59.008Z"),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			JumpHostsAllowed: pulumi.StringArray{
 * 				pulumi.String("192.0.2.1"),
 * 				pulumi.String("192.0.2.5"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			OsGroupName:       pulumi.String("standardAccessGroup"),
 * 			PrivilegeLevel:    pulumi.String("Standard"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			UserList: []networkcloud.KeySetUserArgs{
 * 				{
 * 					AzureUserName: pulumi.String("userABC"),
 * 					Description:   pulumi.String("Needs access for troubleshooting as a part of the support team"),
 * 					SshPublicKey: {
 * 						KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 					},
 * 				},
 * 				{
 * 					AzureUserName: pulumi.String("userXYZ"),
 * 					Description:   pulumi.String("Needs access for troubleshooting as a part of the support team"),
 * 					SshPublicKey: {
 * 						KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.BareMetalMachineKeySet;
 * import com.pulumi.azurenative.networkcloud.BareMetalMachineKeySetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var bareMetalMachineKeySet = new BareMetalMachineKeySet("bareMetalMachineKeySet", BareMetalMachineKeySetArgs.builder()
 *             .azureGroupId("f110271b-XXXX-4163-9b99-214d91660f0e")
 *             .bareMetalMachineKeySetName("bareMetalMachineKeySetName")
 *             .clusterName("clusterName")
 *             .expiration("2022-12-31T23:59:59.008Z")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .jumpHostsAllowed(
 *                 "192.0.2.1",
 *                 "192.0.2.5")
 *             .location("location")
 *             .osGroupName("standardAccessGroup")
 *             .privilegeLevel("Standard")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .userList(
 *                 Map.ofEntries(
 *                     Map.entry("azureUserName", "userABC"),
 *                     Map.entry("description", "Needs access for troubleshooting as a part of the support team"),
 *                     Map.entry("sshPublicKey", Map.of("keyData", "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("azureUserName", "userXYZ"),
 *                     Map.entry("description", "Needs access for troubleshooting as a part of the support team"),
 *                     Map.entry("sshPublicKey", Map.of("keyData", "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"))
 *                 ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:BareMetalMachineKeySet bareMetalMachineKeySetName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/clusters/{clusterName}/bareMetalMachineKeySets/{bareMetalMachineKeySetName}
 * ```
 * @property azureGroupId The object ID of Azure Active Directory group that all users in the list must be in for access to be granted. Users that are not in the group will not have access.
 * @property bareMetalMachineKeySetName The name of the bare metal machine key set.
 * @property clusterName The name of the cluster.
 * @property expiration The date and time after which the users in this key set will be removed from the bare metal machines.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property jumpHostsAllowed The list of IP addresses of jump hosts with management network access from which a login will be allowed for the users.
 * @property location The geo-location where the resource lives
 * @property osGroupName The name of the group that users will be assigned to on the operating system of the machines.
 * @property privilegeLevel The access level allowed for the users in this key set.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property userList The unique list of permitted users.
 */
public data class BareMetalMachineKeySetArgs(
    public val azureGroupId: Output<String>? = null,
    public val bareMetalMachineKeySetName: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val expiration: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val jumpHostsAllowed: Output<List<String>>? = null,
    public val location: Output<String>? = null,
    public val osGroupName: Output<String>? = null,
    public val privilegeLevel: Output<Either<String, BareMetalMachineKeySetPrivilegeLevel>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userList: Output<List<KeySetUserArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.BareMetalMachineKeySetArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.BareMetalMachineKeySetArgs =
        com.pulumi.azurenative.networkcloud.BareMetalMachineKeySetArgs.builder()
            .azureGroupId(azureGroupId?.applyValue({ args0 -> args0 }))
            .bareMetalMachineKeySetName(bareMetalMachineKeySetName?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .expiration(expiration?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .jumpHostsAllowed(jumpHostsAllowed?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .osGroupName(osGroupName?.applyValue({ args0 -> args0 }))
            .privilegeLevel(
                privilegeLevel?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userList(
                userList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BareMetalMachineKeySetArgs].
 */
@PulumiTagMarker
public class BareMetalMachineKeySetArgsBuilder internal constructor() {
    private var azureGroupId: Output<String>? = null

    private var bareMetalMachineKeySetName: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var expiration: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var jumpHostsAllowed: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var osGroupName: Output<String>? = null

    private var privilegeLevel: Output<Either<String, BareMetalMachineKeySetPrivilegeLevel>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userList: Output<List<KeySetUserArgs>>? = null

    /**
     * @param value The object ID of Azure Active Directory group that all users in the list must be in for access to be granted. Users that are not in the group will not have access.
     */
    @JvmName("ttitvheorqgbmlon")
    public suspend fun azureGroupId(`value`: Output<String>) {
        this.azureGroupId = value
    }

    /**
     * @param value The name of the bare metal machine key set.
     */
    @JvmName("vtywimucrwnxiadu")
    public suspend fun bareMetalMachineKeySetName(`value`: Output<String>) {
        this.bareMetalMachineKeySetName = value
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("bbmixvgicyjdvjlh")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The date and time after which the users in this key set will be removed from the bare metal machines.
     */
    @JvmName("rdhdjogrtebkglgs")
    public suspend fun expiration(`value`: Output<String>) {
        this.expiration = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("mgfppwlmckdbkcks")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The list of IP addresses of jump hosts with management network access from which a login will be allowed for the users.
     */
    @JvmName("tvheqwevxufottmt")
    public suspend fun jumpHostsAllowed(`value`: Output<List<String>>) {
        this.jumpHostsAllowed = value
    }

    @JvmName("cupryaewthacseiy")
    public suspend fun jumpHostsAllowed(vararg values: Output<String>) {
        this.jumpHostsAllowed = Output.all(values.asList())
    }

    /**
     * @param values The list of IP addresses of jump hosts with management network access from which a login will be allowed for the users.
     */
    @JvmName("oqtuqxnuajgauuek")
    public suspend fun jumpHostsAllowed(values: List<Output<String>>) {
        this.jumpHostsAllowed = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vddculwosbamwpvv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the group that users will be assigned to on the operating system of the machines.
     */
    @JvmName("oyuyjjmjvohvpuyw")
    public suspend fun osGroupName(`value`: Output<String>) {
        this.osGroupName = value
    }

    /**
     * @param value The access level allowed for the users in this key set.
     */
    @JvmName("emxmfrbcrylqqxbu")
    public suspend
    fun privilegeLevel(`value`: Output<Either<String, BareMetalMachineKeySetPrivilegeLevel>>) {
        this.privilegeLevel = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yefyfnpgmeprbesn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kxtunusfokjiakxu")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The unique list of permitted users.
     */
    @JvmName("oieursdidmqxwyop")
    public suspend fun userList(`value`: Output<List<KeySetUserArgs>>) {
        this.userList = value
    }

    @JvmName("qwqjojnglyudtpxv")
    public suspend fun userList(vararg values: Output<KeySetUserArgs>) {
        this.userList = Output.all(values.asList())
    }

    /**
     * @param values The unique list of permitted users.
     */
    @JvmName("ulayngjkidnvglhr")
    public suspend fun userList(values: List<Output<KeySetUserArgs>>) {
        this.userList = Output.all(values)
    }

    /**
     * @param value The object ID of Azure Active Directory group that all users in the list must be in for access to be granted. Users that are not in the group will not have access.
     */
    @JvmName("mkruwkdqfnelfnnd")
    public suspend fun azureGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureGroupId = mapped
    }

    /**
     * @param value The name of the bare metal machine key set.
     */
    @JvmName("iytwjehkfnumwpco")
    public suspend fun bareMetalMachineKeySetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bareMetalMachineKeySetName = mapped
    }

    /**
     * @param value The name of the cluster.
     */
    @JvmName("ylfiagmesbhwahfx")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The date and time after which the users in this key set will be removed from the bare metal machines.
     */
    @JvmName("mxpwysalstejedly")
    public suspend fun expiration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiration = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("hodqjyjruyulyuxi")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("vvffcrpiewfaoifx")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The list of IP addresses of jump hosts with management network access from which a login will be allowed for the users.
     */
    @JvmName("bucpilbyohcuwvkd")
    public suspend fun jumpHostsAllowed(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jumpHostsAllowed = mapped
    }

    /**
     * @param values The list of IP addresses of jump hosts with management network access from which a login will be allowed for the users.
     */
    @JvmName("saiibjxihwwmmdpn")
    public suspend fun jumpHostsAllowed(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jumpHostsAllowed = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("voahjsbjwbcaeekm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the group that users will be assigned to on the operating system of the machines.
     */
    @JvmName("aitacmdjviuprnpv")
    public suspend fun osGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osGroupName = mapped
    }

    /**
     * @param value The access level allowed for the users in this key set.
     */
    @JvmName("xcmuithvwibhfskj")
    public suspend
    fun privilegeLevel(`value`: Either<String, BareMetalMachineKeySetPrivilegeLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privilegeLevel = mapped
    }

    /**
     * @param value The access level allowed for the users in this key set.
     */
    @JvmName("wlhcrildfghvdlrh")
    public fun privilegeLevel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BareMetalMachineKeySetPrivilegeLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privilegeLevel = mapped
    }

    /**
     * @param value The access level allowed for the users in this key set.
     */
    @JvmName("ttqqqaannnewrnkh")
    public fun privilegeLevel(`value`: BareMetalMachineKeySetPrivilegeLevel) {
        val toBeMapped = Either.ofRight<String, BareMetalMachineKeySetPrivilegeLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privilegeLevel = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cembepxdgenxwppc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yiepelnasuwdrexf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("uhpskjedrhhbgxip")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The unique list of permitted users.
     */
    @JvmName("xrldrowrtmtyegqv")
    public suspend fun userList(`value`: List<KeySetUserArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userList = mapped
    }

    /**
     * @param argument The unique list of permitted users.
     */
    @JvmName("cqlckigcbmamtfrh")
    public suspend fun userList(argument: List<suspend KeySetUserArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { KeySetUserArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.userList = mapped
    }

    /**
     * @param argument The unique list of permitted users.
     */
    @JvmName("hkpoyyunkfqfuubx")
    public suspend fun userList(vararg argument: suspend KeySetUserArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { KeySetUserArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.userList = mapped
    }

    /**
     * @param argument The unique list of permitted users.
     */
    @JvmName("ydxlnfuidduepxqc")
    public suspend fun userList(argument: suspend KeySetUserArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(KeySetUserArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userList = mapped
    }

    /**
     * @param values The unique list of permitted users.
     */
    @JvmName("vgoqjqhsbmmokvka")
    public suspend fun userList(vararg values: KeySetUserArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userList = mapped
    }

    internal fun build(): BareMetalMachineKeySetArgs = BareMetalMachineKeySetArgs(
        azureGroupId = azureGroupId,
        bareMetalMachineKeySetName = bareMetalMachineKeySetName,
        clusterName = clusterName,
        expiration = expiration,
        extendedLocation = extendedLocation,
        jumpHostsAllowed = jumpHostsAllowed,
        location = location,
        osGroupName = osGroupName,
        privilegeLevel = privilegeLevel,
        resourceGroupName = resourceGroupName,
        tags = tags,
        userList = userList,
    )
}
