@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.BgpPeerResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.CniBgpConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.BgpPeerResponse.Companion.toKotlin as bgpPeerResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.CniBgpConfigurationResponse.Companion.toKotlin as cniBgpConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DefaultCniNetwork].
 */
@PulumiTagMarker
public class DefaultCniNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultCniNetworkArgs = DefaultCniNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultCniNetworkArgsBuilder.() -> Unit) {
        val builder = DefaultCniNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DefaultCniNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.networkcloud.DefaultCniNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DefaultCniNetwork(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2022-12-12-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * ## Example Usage
 * ### Create or update default CNI network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultCniNetwork = new AzureNative.NetworkCloud.DefaultCniNetwork("defaultCniNetwork", new()
 *     {
 *         CniBgpConfiguration = new AzureNative.NetworkCloud.Inputs.CniBgpConfigurationArgs
 *         {
 *             BgpPeers = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.BgpPeerArgs
 *                 {
 *                     AsNumber = 64497,
 *                     PeerIp = "203.0.113.254",
 *                 },
 *             },
 *             CommunityAdvertisements = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.CommunityAdvertisementArgs
 *                 {
 *                     Communities = new[]
 *                     {
 *                         "64512:100",
 *                     },
 *                     SubnetPrefix = "192.0.2.0/27",
 *                 },
 *             },
 *             ServiceExternalPrefixes = new[]
 *             {
 *                 "192.0.2.0/28",
 *             },
 *             ServiceLoadBalancerPrefixes = new[]
 *             {
 *                 "192.0.2.16/28",
 *             },
 *         },
 *         DefaultCniNetworkName = "defaultCniNetworkName",
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         IpAllocationType = "DualStack",
 *         Ipv4ConnectedPrefix = "203.0.113.0/24",
 *         Ipv6ConnectedPrefix = "2001:db8:0:3::/64",
 *         L3IsolationDomainId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName",
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         Vlan = 12,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewDefaultCniNetwork(ctx, "defaultCniNetwork", &networkcloud.DefaultCniNetworkArgs{
 * 			CniBgpConfiguration: networkcloud.CniBgpConfigurationResponse{
 * 				BgpPeers: networkcloud.BgpPeerArray{
 * 					&networkcloud.BgpPeerArgs{
 * 						AsNumber: pulumi.Float64(64497),
 * 						PeerIp:   pulumi.String("203.0.113.254"),
 * 					},
 * 				},
 * 				CommunityAdvertisements: networkcloud.CommunityAdvertisementArray{
 * 					&networkcloud.CommunityAdvertisementArgs{
 * 						Communities: pulumi.StringArray{
 * 							pulumi.String("64512:100"),
 * 						},
 * 						SubnetPrefix: pulumi.String("192.0.2.0/27"),
 * 					},
 * 				},
 * 				ServiceExternalPrefixes: pulumi.StringArray{
 * 					pulumi.String("192.0.2.0/28"),
 * 				},
 * 				ServiceLoadBalancerPrefixes: pulumi.StringArray{
 * 					pulumi.String("192.0.2.16/28"),
 * 				},
 * 			},
 * 			DefaultCniNetworkName: pulumi.String("defaultCniNetworkName"),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			IpAllocationType:    pulumi.String("DualStack"),
 * 			Ipv4ConnectedPrefix: pulumi.String("203.0.113.0/24"),
 * 			Ipv6ConnectedPrefix: pulumi.String("2001:db8:0:3::/64"),
 * 			L3IsolationDomainId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName"),
 * 			Location:            pulumi.String("location"),
 * 			ResourceGroupName:   pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			Vlan: pulumi.Float64(12),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.DefaultCniNetwork;
 * import com.pulumi.azurenative.networkcloud.DefaultCniNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultCniNetwork = new DefaultCniNetwork("defaultCniNetwork", DefaultCniNetworkArgs.builder()
 *             .cniBgpConfiguration(Map.ofEntries(
 *                 Map.entry("bgpPeers", Map.ofEntries(
 *                     Map.entry("asNumber", 64497),
 *                     Map.entry("peerIp", "203.0.113.254")
 *                 )),
 *                 Map.entry("communityAdvertisements", Map.ofEntries(
 *                     Map.entry("communities", "64512:100"),
 *                     Map.entry("subnetPrefix", "192.0.2.0/27")
 *                 )),
 *                 Map.entry("serviceExternalPrefixes", "192.0.2.0/28"),
 *                 Map.entry("serviceLoadBalancerPrefixes", "192.0.2.16/28")
 *             ))
 *             .defaultCniNetworkName("defaultCniNetworkName")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .ipAllocationType("DualStack")
 *             .ipv4ConnectedPrefix("203.0.113.0/24")
 *             .ipv6ConnectedPrefix("2001:db8:0:3::/64")
 *             .l3IsolationDomainId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName")
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .vlan(12)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:DefaultCniNetwork defaultcniNetworkName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/defaultCniNetworks/{defaultCniNetworkName}
 * ```
 */
public class DefaultCniNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.DefaultCniNetwork,
) : KotlinCustomResource(javaResource, DefaultCniNetworkMapper) {
    /**
     * The resource ID of the Network Cloud cluster this default CNI network is associated with.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The autonomous system number that the fabric expects to peer with, derived from the associated L3 isolation domain.
     */
    public val cniAsNumber: Output<Double>
        get() = javaResource.cniAsNumber().applyValue({ args0 -> args0 })

    /**
     * The Calico BGP configuration.
     */
    public val cniBgpConfiguration: Output<CniBgpConfigurationResponse>?
        get() = javaResource.cniBgpConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> cniBgpConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The more detailed status of the default CNI network.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The L3 isolation fabric BGP peering connectivity information necessary for BGP peering the Hybrid AKS Cluster with the switch fabric.
     */
    public val fabricBgpPeers: Output<List<BgpPeerResponse>>
        get() = javaResource.fabricBgpPeers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> bgpPeerResponseToKotlin(args0) })
            })
        })

    /**
     * The list of Hybrid AKS cluster resource ID(s) that are associated with this default CNI network.
     */
    public val hybridAksClustersAssociatedIds: Output<List<String>>
        get() = javaResource.hybridAksClustersAssociatedIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The name of the interface that will be present in the virtual machine to represent this network.
     */
    public val interfaceName: Output<String>
        get() = javaResource.interfaceName().applyValue({ args0 -> args0 })

    /**
     * The type of the IP address allocation.
     */
    public val ipAllocationType: Output<String>?
        get() = javaResource.ipAllocationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IPV4 prefix (CIDR) assigned to this default CNI network. It is required when the IP allocation type
     * is IPV4 or DualStack.
     */
    public val ipv4ConnectedPrefix: Output<String>?
        get() = javaResource.ipv4ConnectedPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The IPV6 prefix (CIDR) assigned to this default CNI network. It is required when the IP allocation type
     * is IPV6 or DualStack.
     */
    public val ipv6ConnectedPrefix: Output<String>?
        get() = javaResource.ipv6ConnectedPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource ID of the Network Fabric l3IsolationDomain.
     */
    public val l3IsolationDomainId: Output<String>
        get() = javaResource.l3IsolationDomainId().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the default CNI network.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The VLAN from the l3IsolationDomain that is used for this network.
     */
    public val vlan: Output<Double>
        get() = javaResource.vlan().applyValue({ args0 -> args0 })
}

public object DefaultCniNetworkMapper : ResourceMapper<DefaultCniNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.DefaultCniNetwork::class == javaResource::class

    override fun map(javaResource: Resource): DefaultCniNetwork = DefaultCniNetwork(
        javaResource as
            com.pulumi.azurenative.networkcloud.DefaultCniNetwork,
    )
}

/**
 * @see [DefaultCniNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultCniNetwork].
 */
public suspend fun defaultCniNetwork(
    name: String,
    block: suspend DefaultCniNetworkResourceBuilder.() -> Unit,
): DefaultCniNetwork {
    val builder = DefaultCniNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultCniNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultCniNetwork(name: String): DefaultCniNetwork {
    val builder = DefaultCniNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
