@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.DefaultCniNetworkArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.enums.IpAllocationType
import com.pulumi.azurenative.networkcloud.kotlin.inputs.CniBgpConfigurationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.CniBgpConfigurationArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2022-12-12-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * ## Example Usage
 * ### Create or update default CNI network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var defaultCniNetwork = new AzureNative.NetworkCloud.DefaultCniNetwork("defaultCniNetwork", new()
 *     {
 *         CniBgpConfiguration = new AzureNative.NetworkCloud.Inputs.CniBgpConfigurationArgs
 *         {
 *             BgpPeers = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.BgpPeerArgs
 *                 {
 *                     AsNumber = 64497,
 *                     PeerIp = "203.0.113.254",
 *                 },
 *             },
 *             CommunityAdvertisements = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.CommunityAdvertisementArgs
 *                 {
 *                     Communities = new[]
 *                     {
 *                         "64512:100",
 *                     },
 *                     SubnetPrefix = "192.0.2.0/27",
 *                 },
 *             },
 *             ServiceExternalPrefixes = new[]
 *             {
 *                 "192.0.2.0/28",
 *             },
 *             ServiceLoadBalancerPrefixes = new[]
 *             {
 *                 "192.0.2.16/28",
 *             },
 *         },
 *         DefaultCniNetworkName = "defaultCniNetworkName",
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         IpAllocationType = "DualStack",
 *         Ipv4ConnectedPrefix = "203.0.113.0/24",
 *         Ipv6ConnectedPrefix = "2001:db8:0:3::/64",
 *         L3IsolationDomainId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName",
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         Vlan = 12,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewDefaultCniNetwork(ctx, "defaultCniNetwork", &networkcloud.DefaultCniNetworkArgs{
 * 			CniBgpConfiguration: networkcloud.CniBgpConfigurationResponse{
 * 				BgpPeers: networkcloud.BgpPeerArray{
 * 					&networkcloud.BgpPeerArgs{
 * 						AsNumber: pulumi.Float64(64497),
 * 						PeerIp:   pulumi.String("203.0.113.254"),
 * 					},
 * 				},
 * 				CommunityAdvertisements: networkcloud.CommunityAdvertisementArray{
 * 					&networkcloud.CommunityAdvertisementArgs{
 * 						Communities: pulumi.StringArray{
 * 							pulumi.String("64512:100"),
 * 						},
 * 						SubnetPrefix: pulumi.String("192.0.2.0/27"),
 * 					},
 * 				},
 * 				ServiceExternalPrefixes: pulumi.StringArray{
 * 					pulumi.String("192.0.2.0/28"),
 * 				},
 * 				ServiceLoadBalancerPrefixes: pulumi.StringArray{
 * 					pulumi.String("192.0.2.16/28"),
 * 				},
 * 			},
 * 			DefaultCniNetworkName: pulumi.String("defaultCniNetworkName"),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			IpAllocationType:    pulumi.String("DualStack"),
 * 			Ipv4ConnectedPrefix: pulumi.String("203.0.113.0/24"),
 * 			Ipv6ConnectedPrefix: pulumi.String("2001:db8:0:3::/64"),
 * 			L3IsolationDomainId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName"),
 * 			Location:            pulumi.String("location"),
 * 			ResourceGroupName:   pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			Vlan: pulumi.Float64(12),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.DefaultCniNetwork;
 * import com.pulumi.azurenative.networkcloud.DefaultCniNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var defaultCniNetwork = new DefaultCniNetwork("defaultCniNetwork", DefaultCniNetworkArgs.builder()
 *             .cniBgpConfiguration(Map.ofEntries(
 *                 Map.entry("bgpPeers", Map.ofEntries(
 *                     Map.entry("asNumber", 64497),
 *                     Map.entry("peerIp", "203.0.113.254")
 *                 )),
 *                 Map.entry("communityAdvertisements", Map.ofEntries(
 *                     Map.entry("communities", "64512:100"),
 *                     Map.entry("subnetPrefix", "192.0.2.0/27")
 *                 )),
 *                 Map.entry("serviceExternalPrefixes", "192.0.2.0/28"),
 *                 Map.entry("serviceLoadBalancerPrefixes", "192.0.2.16/28")
 *             ))
 *             .defaultCniNetworkName("defaultCniNetworkName")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .ipAllocationType("DualStack")
 *             .ipv4ConnectedPrefix("203.0.113.0/24")
 *             .ipv6ConnectedPrefix("2001:db8:0:3::/64")
 *             .l3IsolationDomainId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName")
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .vlan(12)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:DefaultCniNetwork defaultcniNetworkName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/defaultCniNetworks/{defaultCniNetworkName}
 * ```
 * @property cniBgpConfiguration The Calico BGP configuration.
 * @property defaultCniNetworkName The name of the default CNI network.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property ipAllocationType The type of the IP address allocation.
 * @property ipv4ConnectedPrefix The IPV4 prefix (CIDR) assigned to this default CNI network. It is required when the IP allocation type
 * is IPV4 or DualStack.
 * @property ipv6ConnectedPrefix The IPV6 prefix (CIDR) assigned to this default CNI network. It is required when the IP allocation type
 * is IPV6 or DualStack.
 * @property l3IsolationDomainId The resource ID of the Network Fabric l3IsolationDomain.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property vlan The VLAN from the l3IsolationDomain that is used for this network.
 */
public data class DefaultCniNetworkArgs(
    public val cniBgpConfiguration: Output<CniBgpConfigurationArgs>? = null,
    public val defaultCniNetworkName: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val ipAllocationType: Output<Either<String, IpAllocationType>>? = null,
    public val ipv4ConnectedPrefix: Output<String>? = null,
    public val ipv6ConnectedPrefix: Output<String>? = null,
    public val l3IsolationDomainId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vlan: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.DefaultCniNetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.DefaultCniNetworkArgs =
        com.pulumi.azurenative.networkcloud.DefaultCniNetworkArgs.builder()
            .cniBgpConfiguration(
                cniBgpConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .defaultCniNetworkName(defaultCniNetworkName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ipAllocationType(
                ipAllocationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .ipv4ConnectedPrefix(ipv4ConnectedPrefix?.applyValue({ args0 -> args0 }))
            .ipv6ConnectedPrefix(ipv6ConnectedPrefix?.applyValue({ args0 -> args0 }))
            .l3IsolationDomainId(l3IsolationDomainId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vlan(vlan?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DefaultCniNetworkArgs].
 */
@PulumiTagMarker
public class DefaultCniNetworkArgsBuilder internal constructor() {
    private var cniBgpConfiguration: Output<CniBgpConfigurationArgs>? = null

    private var defaultCniNetworkName: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var ipAllocationType: Output<Either<String, IpAllocationType>>? = null

    private var ipv4ConnectedPrefix: Output<String>? = null

    private var ipv6ConnectedPrefix: Output<String>? = null

    private var l3IsolationDomainId: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vlan: Output<Double>? = null

    /**
     * @param value The Calico BGP configuration.
     */
    @JvmName("cwemlrkwweiaspag")
    public suspend fun cniBgpConfiguration(`value`: Output<CniBgpConfigurationArgs>) {
        this.cniBgpConfiguration = value
    }

    /**
     * @param value The name of the default CNI network.
     */
    @JvmName("onvdgvkljwwjxfue")
    public suspend fun defaultCniNetworkName(`value`: Output<String>) {
        this.defaultCniNetworkName = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("wegciqglpsfrppgl")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The type of the IP address allocation.
     */
    @JvmName("bictpqlbtphhvvwk")
    public suspend fun ipAllocationType(`value`: Output<Either<String, IpAllocationType>>) {
        this.ipAllocationType = value
    }

    /**
     * @param value The IPV4 prefix (CIDR) assigned to this default CNI network. It is required when the IP allocation type
     * is IPV4 or DualStack.
     */
    @JvmName("ycqwevnsulostamx")
    public suspend fun ipv4ConnectedPrefix(`value`: Output<String>) {
        this.ipv4ConnectedPrefix = value
    }

    /**
     * @param value The IPV6 prefix (CIDR) assigned to this default CNI network. It is required when the IP allocation type
     * is IPV6 or DualStack.
     */
    @JvmName("wdarrmfnlyaxvewf")
    public suspend fun ipv6ConnectedPrefix(`value`: Output<String>) {
        this.ipv6ConnectedPrefix = value
    }

    /**
     * @param value The resource ID of the Network Fabric l3IsolationDomain.
     */
    @JvmName("vcmxrjhrkqmpiebd")
    public suspend fun l3IsolationDomainId(`value`: Output<String>) {
        this.l3IsolationDomainId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ygpddjeugggcgbdq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wiairxpobgoojkxd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("liyogmgdcdbayfrl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The VLAN from the l3IsolationDomain that is used for this network.
     */
    @JvmName("nbvdogcgbynvvsak")
    public suspend fun vlan(`value`: Output<Double>) {
        this.vlan = value
    }

    /**
     * @param value The Calico BGP configuration.
     */
    @JvmName("tnxosaucpdhhlkwd")
    public suspend fun cniBgpConfiguration(`value`: CniBgpConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cniBgpConfiguration = mapped
    }

    /**
     * @param argument The Calico BGP configuration.
     */
    @JvmName("yhokurcalrynwthe")
    public suspend
    fun cniBgpConfiguration(argument: suspend CniBgpConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = CniBgpConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cniBgpConfiguration = mapped
    }

    /**
     * @param value The name of the default CNI network.
     */
    @JvmName("sftrygrocahfswmf")
    public suspend fun defaultCniNetworkName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultCniNetworkName = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("soymixicniasqmjd")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("pqsqmnosvanqhubs")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The type of the IP address allocation.
     */
    @JvmName("qdispnajphoxbeua")
    public suspend fun ipAllocationType(`value`: Either<String, IpAllocationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipAllocationType = mapped
    }

    /**
     * @param value The type of the IP address allocation.
     */
    @JvmName("gasykglwtosajhec")
    public fun ipAllocationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IpAllocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationType = mapped
    }

    /**
     * @param value The type of the IP address allocation.
     */
    @JvmName("ekjihxmmognicxpc")
    public fun ipAllocationType(`value`: IpAllocationType) {
        val toBeMapped = Either.ofRight<String, IpAllocationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipAllocationType = mapped
    }

    /**
     * @param value The IPV4 prefix (CIDR) assigned to this default CNI network. It is required when the IP allocation type
     * is IPV4 or DualStack.
     */
    @JvmName("oiuyvttmvdehvmun")
    public suspend fun ipv4ConnectedPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv4ConnectedPrefix = mapped
    }

    /**
     * @param value The IPV6 prefix (CIDR) assigned to this default CNI network. It is required when the IP allocation type
     * is IPV6 or DualStack.
     */
    @JvmName("aqcjlnfekhllmpru")
    public suspend fun ipv6ConnectedPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipv6ConnectedPrefix = mapped
    }

    /**
     * @param value The resource ID of the Network Fabric l3IsolationDomain.
     */
    @JvmName("ssqajcvoapwopwwe")
    public suspend fun l3IsolationDomainId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.l3IsolationDomainId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("axqbksewhudamnxg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vqblfxaiatmawedc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tiqdjdhgyptwjgxp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vvorctfhfvjhcaeq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The VLAN from the l3IsolationDomain that is used for this network.
     */
    @JvmName("gulormgcwwnxpvfk")
    public suspend fun vlan(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vlan = mapped
    }

    internal fun build(): DefaultCniNetworkArgs = DefaultCniNetworkArgs(
        cniBgpConfiguration = cniBgpConfiguration,
        defaultCniNetworkName = defaultCniNetworkName,
        extendedLocation = extendedLocation,
        ipAllocationType = ipAllocationType,
        ipv4ConnectedPrefix = ipv4ConnectedPrefix,
        ipv6ConnectedPrefix = ipv6ConnectedPrefix,
        l3IsolationDomainId = l3IsolationDomainId,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        vlan = vlan,
    )
}
