@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.NodeConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.NodeConfigurationResponse.Companion.toKotlin as nodeConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [HybridAksCluster].
 */
@PulumiTagMarker
public class HybridAksClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HybridAksClusterArgs = HybridAksClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HybridAksClusterArgsBuilder.() -> Unit) {
        val builder = HybridAksClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HybridAksCluster {
        val builtJavaResource =
            com.pulumi.azurenative.networkcloud.HybridAksCluster(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HybridAksCluster(builtJavaResource)
    }
}

/**
 * The details are specific to the Network Cloud use of the Hybrid AKS cluster.
 * Azure REST API version: 2022-12-12-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * ## Example Usage
 * ### Create or update Hybrid AKS provisioned cluster data
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridAksCluster = new AzureNative.NetworkCloud.HybridAksCluster("hybridAksCluster", new()
 *     {
 *         AssociatedNetworkIds = new[]
 *         {
 *             "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *         },
 *         ControlPlaneCount = 4,
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         HybridAksClusterName = "hybridAksClusterName",
 *         HybridAksProvisionedClusterId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.HybridContainerService/provisionedClusters/hybridAksClusterName",
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         WorkerCount = 8,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewHybridAksCluster(ctx, "hybridAksCluster", &networkcloud.HybridAksClusterArgs{
 * 			AssociatedNetworkIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * 			},
 * 			ControlPlaneCount: pulumi.Float64(4),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HybridAksClusterName:          pulumi.String("hybridAksClusterName"),
 * 			HybridAksProvisionedClusterId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.HybridContainerService/provisionedClusters/hybridAksClusterName"),
 * 			Location:                      pulumi.String("location"),
 * 			ResourceGroupName:             pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			WorkerCount: pulumi.Float64(8),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.HybridAksCluster;
 * import com.pulumi.azurenative.networkcloud.HybridAksClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridAksCluster = new HybridAksCluster("hybridAksCluster", HybridAksClusterArgs.builder()
 *             .associatedNetworkIds("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName")
 *             .controlPlaneCount(4)
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .hybridAksClusterName("hybridAksClusterName")
 *             .hybridAksProvisionedClusterId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.HybridContainerService/provisionedClusters/hybridAksClusterName")
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .workerCount(8)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:HybridAksCluster HybridAksClusterName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/hybridAksClusters/{hybridAksClusterName}
 * ```
 */
public class HybridAksCluster internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.HybridAksCluster,
) : KotlinCustomResource(javaResource, HybridAksClusterMapper) {
    /**
     * The list of resource IDs for the workload networks associated with the Hybrid AKS cluster. It can be any of l2Networks, l3Networks, or trunkedNetworks resources. This field will also contain one cloudServicesNetwork and one defaultCniNetwork.
     */
    public val associatedNetworkIds: Output<List<String>>
        get() = javaResource.associatedNetworkIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The resource ID of the associated cloud services network.
     */
    public val cloudServicesNetworkId: Output<String>
        get() = javaResource.cloudServicesNetworkId().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the Network Cloud cluster hosting the Hybrid AKS cluster.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The number of control plane node VMs.
     */
    public val controlPlaneCount: Output<Double>
        get() = javaResource.controlPlaneCount().applyValue({ args0 -> args0 })

    /**
     * The list of node configurations detailing associated VMs that are part of the control plane nodes of this Hybrid AKS cluster.
     */
    public val controlPlaneNodes: Output<List<NodeConfigurationResponse>>
        get() = javaResource.controlPlaneNodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nodeConfigurationResponseToKotlin(args0) })
            })
        })

    /**
     * The resource ID of the associated default CNI network.
     */
    public val defaultCniNetworkId: Output<String>
        get() = javaResource.defaultCniNetworkId().applyValue({ args0 -> args0 })

    /**
     * The more detailed status of this Hybrid AKS cluster.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The resource ID of the Hybrid AKS cluster that this additional information is for.
     */
    public val hybridAksProvisionedClusterId: Output<String>
        get() = javaResource.hybridAksProvisionedClusterId().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the Hybrid AKS cluster resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The resource IDs of volumes that are attached to the Hybrid AKS cluster.
     */
    public val volumes: Output<List<String>>
        get() = javaResource.volumes().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The number of worker node VMs.
     */
    public val workerCount: Output<Double>
        get() = javaResource.workerCount().applyValue({ args0 -> args0 })

    /**
     * The list of node configurations detailing associated VMs that are part of the worker nodes of this Hybrid AKS cluster.
     */
    public val workerNodes: Output<List<NodeConfigurationResponse>>
        get() = javaResource.workerNodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    nodeConfigurationResponseToKotlin(args0)
                })
            })
        })
}

public object HybridAksClusterMapper : ResourceMapper<HybridAksCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.HybridAksCluster::class == javaResource::class

    override fun map(javaResource: Resource): HybridAksCluster = HybridAksCluster(
        javaResource as
            com.pulumi.azurenative.networkcloud.HybridAksCluster,
    )
}

/**
 * @see [HybridAksCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HybridAksCluster].
 */
public suspend fun hybridAksCluster(
    name: String,
    block: suspend HybridAksClusterResourceBuilder.() -> Unit,
): HybridAksCluster {
    val builder = HybridAksClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HybridAksCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hybridAksCluster(name: String): HybridAksCluster {
    val builder = HybridAksClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
