@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.HybridAksClusterArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The details are specific to the Network Cloud use of the Hybrid AKS cluster.
 * Azure REST API version: 2022-12-12-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * ## Example Usage
 * ### Create or update Hybrid AKS provisioned cluster data
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hybridAksCluster = new AzureNative.NetworkCloud.HybridAksCluster("hybridAksCluster", new()
 *     {
 *         AssociatedNetworkIds = new[]
 *         {
 *             "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *         },
 *         ControlPlaneCount = 4,
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         HybridAksClusterName = "hybridAksClusterName",
 *         HybridAksProvisionedClusterId = "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.HybridContainerService/provisionedClusters/hybridAksClusterName",
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         WorkerCount = 8,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewHybridAksCluster(ctx, "hybridAksCluster", &networkcloud.HybridAksClusterArgs{
 * 			AssociatedNetworkIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * 			},
 * 			ControlPlaneCount: pulumi.Float64(4),
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			HybridAksClusterName:          pulumi.String("hybridAksClusterName"),
 * 			HybridAksProvisionedClusterId: pulumi.String("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.HybridContainerService/provisionedClusters/hybridAksClusterName"),
 * 			Location:                      pulumi.String("location"),
 * 			ResourceGroupName:             pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			WorkerCount: pulumi.Float64(8),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.HybridAksCluster;
 * import com.pulumi.azurenative.networkcloud.HybridAksClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hybridAksCluster = new HybridAksCluster("hybridAksCluster", HybridAksClusterArgs.builder()
 *             .associatedNetworkIds("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName")
 *             .controlPlaneCount(4)
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .hybridAksClusterName("hybridAksClusterName")
 *             .hybridAksProvisionedClusterId("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.HybridContainerService/provisionedClusters/hybridAksClusterName")
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .workerCount(8)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:HybridAksCluster HybridAksClusterName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/hybridAksClusters/{hybridAksClusterName}
 * ```
 * @property associatedNetworkIds The list of resource IDs for the workload networks associated with the Hybrid AKS cluster. It can be any of l2Networks, l3Networks, or trunkedNetworks resources. This field will also contain one cloudServicesNetwork and one defaultCniNetwork.
 * @property controlPlaneCount The number of control plane node VMs.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property hybridAksClusterName The name of the Hybrid AKS cluster.
 * @property hybridAksProvisionedClusterId The resource ID of the Hybrid AKS cluster that this additional information is for.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property workerCount The number of worker node VMs.
 */
public data class HybridAksClusterArgs(
    public val associatedNetworkIds: Output<List<String>>? = null,
    public val controlPlaneCount: Output<Double>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val hybridAksClusterName: Output<String>? = null,
    public val hybridAksProvisionedClusterId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val workerCount: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.HybridAksClusterArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.HybridAksClusterArgs =
        com.pulumi.azurenative.networkcloud.HybridAksClusterArgs.builder()
            .associatedNetworkIds(associatedNetworkIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .controlPlaneCount(controlPlaneCount?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hybridAksClusterName(hybridAksClusterName?.applyValue({ args0 -> args0 }))
            .hybridAksProvisionedClusterId(hybridAksProvisionedClusterId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .workerCount(workerCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridAksClusterArgs].
 */
@PulumiTagMarker
public class HybridAksClusterArgsBuilder internal constructor() {
    private var associatedNetworkIds: Output<List<String>>? = null

    private var controlPlaneCount: Output<Double>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var hybridAksClusterName: Output<String>? = null

    private var hybridAksProvisionedClusterId: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var workerCount: Output<Double>? = null

    /**
     * @param value The list of resource IDs for the workload networks associated with the Hybrid AKS cluster. It can be any of l2Networks, l3Networks, or trunkedNetworks resources. This field will also contain one cloudServicesNetwork and one defaultCniNetwork.
     */
    @JvmName("suaiedbkmlmxmgdj")
    public suspend fun associatedNetworkIds(`value`: Output<List<String>>) {
        this.associatedNetworkIds = value
    }

    @JvmName("njijvlluvhwjlwic")
    public suspend fun associatedNetworkIds(vararg values: Output<String>) {
        this.associatedNetworkIds = Output.all(values.asList())
    }

    /**
     * @param values The list of resource IDs for the workload networks associated with the Hybrid AKS cluster. It can be any of l2Networks, l3Networks, or trunkedNetworks resources. This field will also contain one cloudServicesNetwork and one defaultCniNetwork.
     */
    @JvmName("bsmdedorjqgvmbys")
    public suspend fun associatedNetworkIds(values: List<Output<String>>) {
        this.associatedNetworkIds = Output.all(values)
    }

    /**
     * @param value The number of control plane node VMs.
     */
    @JvmName("aeitqkjdqwvkeuev")
    public suspend fun controlPlaneCount(`value`: Output<Double>) {
        this.controlPlaneCount = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("yknblpmixfkewtgm")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The name of the Hybrid AKS cluster.
     */
    @JvmName("xjvemqxjmcrfcaan")
    public suspend fun hybridAksClusterName(`value`: Output<String>) {
        this.hybridAksClusterName = value
    }

    /**
     * @param value The resource ID of the Hybrid AKS cluster that this additional information is for.
     */
    @JvmName("lfxwhrwqgsdukykv")
    public suspend fun hybridAksProvisionedClusterId(`value`: Output<String>) {
        this.hybridAksProvisionedClusterId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tmixdumeelfdxsum")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nawqigeqqufwvwxi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("acvmisamsrffbkcg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The number of worker node VMs.
     */
    @JvmName("fnjgtppkwnhgqael")
    public suspend fun workerCount(`value`: Output<Double>) {
        this.workerCount = value
    }

    /**
     * @param value The list of resource IDs for the workload networks associated with the Hybrid AKS cluster. It can be any of l2Networks, l3Networks, or trunkedNetworks resources. This field will also contain one cloudServicesNetwork and one defaultCniNetwork.
     */
    @JvmName("gupcmgytdrgrmtse")
    public suspend fun associatedNetworkIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.associatedNetworkIds = mapped
    }

    /**
     * @param values The list of resource IDs for the workload networks associated with the Hybrid AKS cluster. It can be any of l2Networks, l3Networks, or trunkedNetworks resources. This field will also contain one cloudServicesNetwork and one defaultCniNetwork.
     */
    @JvmName("dixfkptuvvwmoyik")
    public suspend fun associatedNetworkIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.associatedNetworkIds = mapped
    }

    /**
     * @param value The number of control plane node VMs.
     */
    @JvmName("efkagvgwmqtupvsa")
    public suspend fun controlPlaneCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.controlPlaneCount = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("bjibqygptkxqmixy")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("wqydxhvvmnqtjbni")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The name of the Hybrid AKS cluster.
     */
    @JvmName("ebqxkuhhwmobnrgw")
    public suspend fun hybridAksClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridAksClusterName = mapped
    }

    /**
     * @param value The resource ID of the Hybrid AKS cluster that this additional information is for.
     */
    @JvmName("msjaicdtnlbmgntf")
    public suspend fun hybridAksProvisionedClusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hybridAksProvisionedClusterId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("bwowinhbbiomrxmw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ijimuqmcgwtlbxgk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("okualyvarmpyvbgd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("oqrytdjawfreflkw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The number of worker node VMs.
     */
    @JvmName("xvpqwmkrnildwefb")
    public suspend fun workerCount(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workerCount = mapped
    }

    internal fun build(): HybridAksClusterArgs = HybridAksClusterArgs(
        associatedNetworkIds = associatedNetworkIds,
        controlPlaneCount = controlPlaneCount,
        extendedLocation = extendedLocation,
        hybridAksClusterName = hybridAksClusterName,
        hybridAksProvisionedClusterId = hybridAksProvisionedClusterId,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
        workerCount = workerCount,
    )
}
