@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.AadConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministratorConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AvailableUpgradeResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ControlPlaneNodeConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.FeatureStatusResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.InitialAgentPoolConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KubernetesClusterNodeResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ManagedResourceGroupConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.NetworkConfigurationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AadConfigurationResponse.Companion.toKotlin as aadConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AdministratorConfigurationResponse.Companion.toKotlin as administratorConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.AvailableUpgradeResponse.Companion.toKotlin as availableUpgradeResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ControlPlaneNodeConfigurationResponse.Companion.toKotlin as controlPlaneNodeConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.FeatureStatusResponse.Companion.toKotlin as featureStatusResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.InitialAgentPoolConfigurationResponse.Companion.toKotlin as initialAgentPoolConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.KubernetesClusterNodeResponse.Companion.toKotlin as kubernetesClusterNodeResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ManagedResourceGroupConfigurationResponse.Companion.toKotlin as managedResourceGroupConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.NetworkConfigurationResponse.Companion.toKotlin as networkConfigurationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [KubernetesCluster].
 */
@PulumiTagMarker
public class KubernetesClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: KubernetesClusterArgs = KubernetesClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend KubernetesClusterArgsBuilder.() -> Unit) {
        val builder = KubernetesClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): KubernetesCluster {
        val builtJavaResource =
            com.pulumi.azurenative.networkcloud.KubernetesCluster(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return KubernetesCluster(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-05-01-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update Kubernetes cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kubernetesCluster = new AzureNative.NetworkCloud.KubernetesCluster("kubernetesCluster", new()
 *     {
 *         AadConfiguration = new AzureNative.NetworkCloud.Inputs.AadConfigurationArgs
 *         {
 *             AdminGroupObjectIds = new[]
 *             {
 *                 "ffffffff-ffff-ffff-ffff-ffffffffffff",
 *             },
 *         },
 *         AdministratorConfiguration = new AzureNative.NetworkCloud.Inputs.AdministratorConfigurationArgs
 *         {
 *             AdminUsername = "azure",
 *             SshPublicKeys = new[]
 *             {
 *                 new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                 {
 *                     KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                 },
 *             },
 *         },
 *         ControlPlaneNodeConfiguration = new AzureNative.NetworkCloud.Inputs.ControlPlaneNodeConfigurationArgs
 *         {
 *             AdministratorConfiguration = new AzureNative.NetworkCloud.Inputs.AdministratorConfigurationArgs
 *             {
 *                 AdminUsername = "azure",
 *                 SshPublicKeys = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                     {
 *                         KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                     },
 *                 },
 *             },
 *             AvailabilityZones = new[]
 *             {
 *                 "1",
 *                 "2",
 *                 "3",
 *             },
 *             Count = 3,
 *             VmSkuName = "NC_G4_v1",
 *         },
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         InitialAgentPoolConfigurations = new[]
 *         {
 *             new AzureNative.NetworkCloud.Inputs.InitialAgentPoolConfigurationArgs
 *             {
 *                 AdministratorConfiguration = new AzureNative.NetworkCloud.Inputs.AdministratorConfigurationArgs
 *                 {
 *                     AdminUsername = "azure",
 *                     SshPublicKeys = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.SshPublicKeyArgs
 *                         {
 *                             KeyData = "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm",
 *                         },
 *                     },
 *                 },
 *                 AgentOptions = new AzureNative.NetworkCloud.Inputs.AgentOptionsArgs
 *                 {
 *                     HugepagesCount = 96,
 *                     HugepagesSize = "1G",
 *                 },
 *                 AttachedNetworkConfiguration = new AzureNative.NetworkCloud.Inputs.AttachedNetworkConfigurationArgs
 *                 {
 *                     L2Networks = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.L2NetworkAttachmentConfigurationArgs
 *                         {
 *                             NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName",
 *                             PluginType = "DPDK",
 *                         },
 *                     },
 *                     L3Networks = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.L3NetworkAttachmentConfigurationArgs
 *                         {
 *                             IpamEnabled = "False",
 *                             NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *                             PluginType = "SRIOV",
 *                         },
 *                     },
 *                     TrunkedNetworks = new[]
 *                     {
 *                         new AzureNative.NetworkCloud.Inputs.TrunkedNetworkAttachmentConfigurationArgs
 *                         {
 *                             NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName",
 *                             PluginType = "MACVLAN",
 *                         },
 *                     },
 *                 },
 *                 AvailabilityZones = new[]
 *                 {
 *                     "1",
 *                     "2",
 *                     "3",
 *                 },
 *                 Count = 3,
 *                 Labels = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.KubernetesLabelArgs
 *                     {
 *                         Key = "kubernetes.label",
 *                         Value = "true",
 *                     },
 *                 },
 *                 Mode = "System",
 *                 Name = "SystemPool-1",
 *                 Taints = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.KubernetesLabelArgs
 *                     {
 *                         Key = "kubernetes.taint",
 *                         Value = "true",
 *                     },
 *                 },
 *                 UpgradeSettings = new AzureNative.NetworkCloud.Inputs.AgentPoolUpgradeSettingsArgs
 *                 {
 *                     MaxSurge = "1",
 *                 },
 *                 VmSkuName = "NC_M16_v1",
 *             },
 *         },
 *         KubernetesClusterName = "kubernetesClusterName",
 *         KubernetesVersion = "1.24.12-1",
 *         Location = "location",
 *         ManagedResourceGroupConfiguration = new AzureNative.NetworkCloud.Inputs.ManagedResourceGroupConfigurationArgs
 *         {
 *             Location = "East US",
 *             Name = "my-managed-rg",
 *         },
 *         NetworkConfiguration = new AzureNative.NetworkCloud.Inputs.NetworkConfigurationArgs
 *         {
 *             AttachedNetworkConfiguration = new AzureNative.NetworkCloud.Inputs.AttachedNetworkConfigurationArgs
 *             {
 *                 L2Networks = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.L2NetworkAttachmentConfigurationArgs
 *                     {
 *                         NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName",
 *                         PluginType = "DPDK",
 *                     },
 *                 },
 *                 L3Networks = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.L3NetworkAttachmentConfigurationArgs
 *                     {
 *                         IpamEnabled = "False",
 *                         NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *                         PluginType = "SRIOV",
 *                     },
 *                 },
 *                 TrunkedNetworks = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.TrunkedNetworkAttachmentConfigurationArgs
 *                     {
 *                         NetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName",
 *                         PluginType = "MACVLAN",
 *                     },
 *                 },
 *             },
 *             BgpServiceLoadBalancerConfiguration = new AzureNative.NetworkCloud.Inputs.BgpServiceLoadBalancerConfigurationArgs
 *             {
 *                 BgpAdvertisements = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.BgpAdvertisementArgs
 *                     {
 *                         AdvertiseToFabric = "True",
 *                         Communities = new[]
 *                         {
 *                             "64512:100",
 *                         },
 *                         IpAddressPools = new[]
 *                         {
 *                             "pool1",
 *                         },
 *                         Peers = new[]
 *                         {
 *                             "peer1",
 *                         },
 *                     },
 *                 },
 *                 BgpPeers = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.ServiceLoadBalancerBgpPeerArgs
 *                     {
 *                         BfdEnabled = "False",
 *                         BgpMultiHop = "False",
 *                         HoldTime = "P300s",
 *                         KeepAliveTime = "P300s",
 *                         MyAsn = 64512,
 *                         Name = "peer1",
 *                         PeerAddress = "203.0.113.254",
 *                         PeerAsn = 64497,
 *                         PeerPort = 179,
 *                     },
 *                 },
 *                 FabricPeeringEnabled = "True",
 *                 IpAddressPools = new[]
 *                 {
 *                     new AzureNative.NetworkCloud.Inputs.IpAddressPoolArgs
 *                     {
 *                         Addresses = new[]
 *                         {
 *                             "198.51.102.0/24",
 *                         },
 *                         AutoAssign = "True",
 *                         Name = "pool1",
 *                         OnlyUseHostIps = "True",
 *                     },
 *                 },
 *             },
 *             CloudServicesNetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName",
 *             CniNetworkId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName",
 *             DnsServiceIp = "198.51.101.2",
 *             PodCidrs = new[]
 *             {
 *                 "198.51.100.0/24",
 *             },
 *             ServiceCidrs = new[]
 *             {
 *                 "198.51.101.0/24",
 *             },
 *         },
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := networkcloud.NewKubernetesCluster(ctx, "kubernetesCluster", &networkcloud.KubernetesClusterArgs{
 * AadConfiguration: &networkcloud.AadConfigurationArgs{
 * AdminGroupObjectIds: pulumi.StringArray{
 * pulumi.String("ffffffff-ffff-ffff-ffff-ffffffffffff"),
 * },
 * },
 * AdministratorConfiguration: networkcloud.AdministratorConfigurationResponse{
 * AdminUsername: pulumi.String("azure"),
 * SshPublicKeys: networkcloud.SshPublicKeyArray{
 * &networkcloud.SshPublicKeyArgs{
 * KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * },
 * },
 * },
 * ControlPlaneNodeConfiguration: networkcloud.ControlPlaneNodeConfigurationResponse{
 * AdministratorConfiguration: interface{}{
 * AdminUsername: pulumi.String("azure"),
 * SshPublicKeys: networkcloud.SshPublicKeyArray{
 * &networkcloud.SshPublicKeyArgs{
 * KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * },
 * },
 * },
 * AvailabilityZones: pulumi.StringArray{
 * pulumi.String("1"),
 * pulumi.String("2"),
 * pulumi.String("3"),
 * },
 * Count: pulumi.Float64(3),
 * VmSkuName: pulumi.String("NC_G4_v1"),
 * },
 * ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * Type: pulumi.String("CustomLocation"),
 * },
 * InitialAgentPoolConfigurations: []networkcloud.InitialAgentPoolConfigurationArgs{
 * {
 * AdministratorConfiguration: {
 * AdminUsername: pulumi.String("azure"),
 * SshPublicKeys: networkcloud.SshPublicKeyArray{
 * {
 * KeyData: pulumi.String("ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"),
 * },
 * },
 * },
 * AgentOptions: {
 * HugepagesCount: pulumi.Float64(96),
 * HugepagesSize: pulumi.String("1G"),
 * },
 * AttachedNetworkConfiguration: {
 * L2Networks: networkcloud.L2NetworkAttachmentConfigurationArray{
 * {
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 * PluginType: pulumi.String("DPDK"),
 * },
 * },
 * L3Networks: networkcloud.L3NetworkAttachmentConfigurationArray{
 * {
 * IpamEnabled: pulumi.String("False"),
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * PluginType: pulumi.String("SRIOV"),
 * },
 * },
 * TrunkedNetworks: networkcloud.TrunkedNetworkAttachmentConfigurationArray{
 * {
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 * PluginType: pulumi.String("MACVLAN"),
 * },
 * },
 * },
 * AvailabilityZones: pulumi.StringArray{
 * pulumi.String("1"),
 * pulumi.String("2"),
 * pulumi.String("3"),
 * },
 * Count: pulumi.Float64(3),
 * Labels: networkcloud.KubernetesLabelArray{
 * {
 * Key: pulumi.String("kubernetes.label"),
 * Value: pulumi.String("true"),
 * },
 * },
 * Mode: pulumi.String("System"),
 * Name: pulumi.String("SystemPool-1"),
 * Taints: networkcloud.KubernetesLabelArray{
 * {
 * Key: pulumi.String("kubernetes.taint"),
 * Value: pulumi.String("true"),
 * },
 * },
 * UpgradeSettings: {
 * MaxSurge: pulumi.String("1"),
 * },
 * VmSkuName: pulumi.String("NC_M16_v1"),
 * },
 * },
 * KubernetesClusterName: pulumi.String("kubernetesClusterName"),
 * KubernetesVersion: pulumi.String("1.24.12-1"),
 * Location: pulumi.String("location"),
 * ManagedResourceGroupConfiguration: &networkcloud.ManagedResourceGroupConfigurationArgs{
 * Location: pulumi.String("East US"),
 * Name: pulumi.String("my-managed-rg"),
 * },
 * NetworkConfiguration: networkcloud.NetworkConfigurationResponse{
 * AttachedNetworkConfiguration: interface{}{
 * L2Networks: networkcloud.L2NetworkAttachmentConfigurationArray{
 * &networkcloud.L2NetworkAttachmentConfigurationArgs{
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 * PluginType: pulumi.String("DPDK"),
 * },
 * },
 * L3Networks: networkcloud.L3NetworkAttachmentConfigurationArray{
 * &networkcloud.L3NetworkAttachmentConfigurationArgs{
 * IpamEnabled: pulumi.String("False"),
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * PluginType: pulumi.String("SRIOV"),
 * },
 * },
 * TrunkedNetworks: networkcloud.TrunkedNetworkAttachmentConfigurationArray{
 * &networkcloud.TrunkedNetworkAttachmentConfigurationArgs{
 * NetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 * PluginType: pulumi.String("MACVLAN"),
 * },
 * },
 * },
 * BgpServiceLoadBalancerConfiguration: interface{}{
 * BgpAdvertisements: networkcloud.BgpAdvertisementArray{
 * &networkcloud.BgpAdvertisementArgs{
 * AdvertiseToFabric: pulumi.String("True"),
 * Communities: pulumi.StringArray{
 * pulumi.String("64512:100"),
 * },
 * IpAddressPools: pulumi.StringArray{
 * pulumi.String("pool1"),
 * },
 * Peers: pulumi.StringArray{
 * pulumi.String("peer1"),
 * },
 * },
 * },
 * BgpPeers: networkcloud.ServiceLoadBalancerBgpPeerArray{
 * &networkcloud.ServiceLoadBalancerBgpPeerArgs{
 * BfdEnabled: pulumi.String("False"),
 * BgpMultiHop: pulumi.String("False"),
 * HoldTime: pulumi.String("P300s"),
 * KeepAliveTime: pulumi.String("P300s"),
 * MyAsn: pulumi.Float64(64512),
 * Name: pulumi.String("peer1"),
 * PeerAddress: pulumi.String("203.0.113.254"),
 * PeerAsn: pulumi.Float64(64497),
 * PeerPort: pulumi.Float64(179),
 * },
 * },
 * FabricPeeringEnabled: pulumi.String("True"),
 * IpAddressPools: networkcloud.IpAddressPoolArray{
 * &networkcloud.IpAddressPoolArgs{
 * Addresses: pulumi.StringArray{
 * pulumi.String("198.51.102.0/24"),
 * },
 * AutoAssign: pulumi.String("True"),
 * Name: pulumi.String("pool1"),
 * OnlyUseHostIps: pulumi.String("True"),
 * },
 * },
 * },
 * CloudServicesNetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
 * CniNetworkId: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 * DnsServiceIp: pulumi.String("198.51.101.2"),
 * PodCidrs: pulumi.StringArray{
 * pulumi.String("198.51.100.0/24"),
 * },
 * ServiceCidrs: pulumi.StringArray{
 * pulumi.String("198.51.101.0/24"),
 * },
 * },
 * ResourceGroupName: pulumi.String("resourceGroupName"),
 * Tags: pulumi.StringMap{
 * "key1": pulumi.String("myvalue1"),
 * "key2": pulumi.String("myvalue2"),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.KubernetesCluster;
 * import com.pulumi.azurenative.networkcloud.KubernetesClusterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kubernetesCluster = new KubernetesCluster("kubernetesCluster", KubernetesClusterArgs.builder()
 *             .aadConfiguration(Map.of("adminGroupObjectIds", "ffffffff-ffff-ffff-ffff-ffffffffffff"))
 *             .administratorConfiguration(Map.ofEntries(
 *                 Map.entry("adminUsername", "azure"),
 *                 Map.entry("sshPublicKeys", Map.of("keyData", "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"))
 *             ))
 *             .controlPlaneNodeConfiguration(Map.ofEntries(
 *                 Map.entry("administratorConfiguration", Map.ofEntries(
 *                     Map.entry("adminUsername", "azure"),
 *                     Map.entry("sshPublicKeys", Map.of("keyData", "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"))
 *                 )),
 *                 Map.entry("availabilityZones",
 *                     "1",
 *                     "2",
 *                     "3"),
 *                 Map.entry("count", 3),
 *                 Map.entry("vmSkuName", "NC_G4_v1")
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .initialAgentPoolConfigurations(Map.ofEntries(
 *                 Map.entry("administratorConfiguration", Map.ofEntries(
 *                     Map.entry("adminUsername", "azure"),
 *                     Map.entry("sshPublicKeys", Map.of("keyData", "ssh-rsa AAtsE3njSONzDYRIZv/WLjVuMfrUSByHp+jfaaOLHTIIB4fJvo6dQUZxE20w2iDHV3tEkmnTo84eba97VMueQD6OzJPEyWZMRpz8UYWOd0IXeRqiFu1lawNblZhwNT/ojNZfpB3af/YDzwQCZgTcTRyNNhL4o/blKUmug0daSsSXISTRnIDpcf5qytjs1Xo+yYyJMvzLL59mhAyb3p/cD+Y3/s3WhAx+l0XOKpzXnblrv9d3q4c2tWmm/SyFqthaqd0= admin@vm"))
 *                 )),
 *                 Map.entry("agentOptions", Map.ofEntries(
 *                     Map.entry("hugepagesCount", 96),
 *                     Map.entry("hugepagesSize", "1G")
 *                 )),
 *                 Map.entry("attachedNetworkConfiguration", Map.ofEntries(
 *                     Map.entry("l2Networks", Map.ofEntries(
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 *                         Map.entry("pluginType", "DPDK")
 *                     )),
 *                     Map.entry("l3Networks", Map.ofEntries(
 *                         Map.entry("ipamEnabled", "False"),
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 *                         Map.entry("pluginType", "SRIOV")
 *                     )),
 *                     Map.entry("trunkedNetworks", Map.ofEntries(
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 *                         Map.entry("pluginType", "MACVLAN")
 *                     ))
 *                 )),
 *                 Map.entry("availabilityZones",
 *                     "1",
 *                     "2",
 *                     "3"),
 *                 Map.entry("count", 3),
 *                 Map.entry("labels", Map.ofEntries(
 *                     Map.entry("key", "kubernetes.label"),
 *                     Map.entry("value", "true")
 *                 )),
 *                 Map.entry("mode", "System"),
 *                 Map.entry("name", "SystemPool-1"),
 *                 Map.entry("taints", Map.ofEntries(
 *                     Map.entry("key", "kubernetes.taint"),
 *                     Map.entry("value", "true")
 *                 )),
 *                 Map.entry("upgradeSettings", Map.of("maxSurge", "1")),
 *                 Map.entry("vmSkuName", "NC_M16_v1")
 *             ))
 *             .kubernetesClusterName("kubernetesClusterName")
 *             .kubernetesVersion("1.24.12-1")
 *             .location("location")
 *             .managedResourceGroupConfiguration(Map.ofEntries(
 *                 Map.entry("location", "East US"),
 *                 Map.entry("name", "my-managed-rg")
 *             ))
 *             .networkConfiguration(Map.ofEntries(
 *                 Map.entry("attachedNetworkConfiguration", Map.ofEntries(
 *                     Map.entry("l2Networks", Map.ofEntries(
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l2Networks/l2NetworkName"),
 *                         Map.entry("pluginType", "DPDK")
 *                     )),
 *                     Map.entry("l3Networks", Map.ofEntries(
 *                         Map.entry("ipamEnabled", "False"),
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 *                         Map.entry("pluginType", "SRIOV")
 *                     )),
 *                     Map.entry("trunkedNetworks", Map.ofEntries(
 *                         Map.entry("networkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/trunkedNetworks/trunkedNetworkName"),
 *                         Map.entry("pluginType", "MACVLAN")
 *                     ))
 *                 )),
 *                 Map.entry("bgpServiceLoadBalancerConfiguration", Map.ofEntries(
 *                     Map.entry("bgpAdvertisements", Map.ofEntries(
 *                         Map.entry("advertiseToFabric", "True"),
 *                         Map.entry("communities", "64512:100"),
 *                         Map.entry("ipAddressPools", "pool1"),
 *                         Map.entry("peers", "peer1")
 *                     )),
 *                     Map.entry("bgpPeers", Map.ofEntries(
 *                         Map.entry("bfdEnabled", "False"),
 *                         Map.entry("bgpMultiHop", "False"),
 *                         Map.entry("holdTime", "P300s"),
 *                         Map.entry("keepAliveTime", "P300s"),
 *                         Map.entry("myAsn", 64512),
 *                         Map.entry("name", "peer1"),
 *                         Map.entry("peerAddress", "203.0.113.254"),
 *                         Map.entry("peerAsn", 64497),
 *                         Map.entry("peerPort", 179)
 *                     )),
 *                     Map.entry("fabricPeeringEnabled", "True"),
 *                     Map.entry("ipAddressPools", Map.ofEntries(
 *                         Map.entry("addresses", "198.51.102.0/24"),
 *                         Map.entry("autoAssign", "True"),
 *                         Map.entry("name", "pool1"),
 *                         Map.entry("onlyUseHostIps", "True")
 *                     ))
 *                 )),
 *                 Map.entry("cloudServicesNetworkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/cloudServicesNetworks/cloudServicesNetworkName"),
 *                 Map.entry("cniNetworkId", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/l3Networks/l3NetworkName"),
 *                 Map.entry("dnsServiceIp", "198.51.101.2"),
 *                 Map.entry("podCidrs", "198.51.100.0/24"),
 *                 Map.entry("serviceCidrs", "198.51.101.0/24")
 *             ))
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:KubernetesCluster KubernetesClusterName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/kubernetesClusters/{kubernetesClusterName}
 * ```
 */
public class KubernetesCluster internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.KubernetesCluster,
) : KotlinCustomResource(javaResource, KubernetesClusterMapper) {
    /**
     * The Azure Active Directory Integration properties.
     */
    public val aadConfiguration: Output<AadConfigurationResponse>?
        get() = javaResource.aadConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> aadConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The administrative credentials that will be applied to the control plane and agent pool nodes that do not specify their own values.
     */
    public val administratorConfiguration: Output<AdministratorConfigurationResponse>?
        get() = javaResource.administratorConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> administratorConfigurationResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The full list of network resource IDs that are attached to this cluster, including those attached only to specific agent pools.
     */
    public val attachedNetworkIds: Output<List<String>>
        get() = javaResource.attachedNetworkIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The list of versions that this Kubernetes cluster can be upgraded to.
     */
    public val availableUpgrades: Output<List<AvailableUpgradeResponse>>
        get() = javaResource.availableUpgrades().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> availableUpgradeResponseToKotlin(args0) })
            })
        })

    /**
     * The resource ID of the Network Cloud cluster.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The resource ID of the connected cluster set up when this Kubernetes cluster is created.
     */
    public val connectedClusterId: Output<String>
        get() = javaResource.connectedClusterId().applyValue({ args0 -> args0 })

    /**
     * The current running version of Kubernetes on the control plane.
     */
    public val controlPlaneKubernetesVersion: Output<String>
        get() = javaResource.controlPlaneKubernetesVersion().applyValue({ args0 -> args0 })

    /**
     * The defining characteristics of the control plane for this Kubernetes Cluster.
     */
    public val controlPlaneNodeConfiguration: Output<ControlPlaneNodeConfigurationResponse>
        get() = javaResource.controlPlaneNodeConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                controlPlaneNodeConfigurationResponseToKotlin(args0)
            })
        })

    /**
     * The current status of the Kubernetes cluster.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * The current feature settings.
     */
    public val featureStatuses: Output<List<FeatureStatusResponse>>
        get() = javaResource.featureStatuses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> featureStatusResponseToKotlin(args0) })
            })
        })

    /**
     * The agent pools that are created with this Kubernetes cluster for running critical system services and workloads. This data in this field is only used during creation, and the field will be empty following the creation of the Kubernetes Cluster. After creation, the management of agent pools is done using the agentPools sub-resource.
     */
    public val initialAgentPoolConfigurations: Output<List<InitialAgentPoolConfigurationResponse>>
        get() = javaResource.initialAgentPoolConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> initialAgentPoolConfigurationResponseToKotlin(args0) })
            })
        })

    /**
     * The Kubernetes version for this cluster. Accepts n.n, n.n.n, and n.n.n-n format. The interpreted version used will be resolved into this field after creation or update.
     */
    public val kubernetesVersion: Output<String>
        get() = javaResource.kubernetesVersion().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The configuration of the managed resource group associated with the resource.
     */
    public val managedResourceGroupConfiguration: Output<ManagedResourceGroupConfigurationResponse>?
        get() = javaResource.managedResourceGroupConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedResourceGroupConfigurationResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The configuration of the Kubernetes cluster networking, including the attachment of networks that span the cluster.
     */
    public val networkConfiguration: Output<NetworkConfigurationResponse>
        get() = javaResource.networkConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                networkConfigurationResponseToKotlin(args0)
            })
        })

    /**
     * The details of the nodes in this cluster.
     */
    public val nodes: Output<List<KubernetesClusterNodeResponse>>
        get() = javaResource.nodes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    kubernetesClusterNodeResponseToKotlin(args0)
                })
            })
        })

    /**
     * The provisioning state of the Kubernetes cluster resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object KubernetesClusterMapper : ResourceMapper<KubernetesCluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.KubernetesCluster::class == javaResource::class

    override fun map(javaResource: Resource): KubernetesCluster = KubernetesCluster(
        javaResource as
            com.pulumi.azurenative.networkcloud.KubernetesCluster,
    )
}

/**
 * @see [KubernetesCluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [KubernetesCluster].
 */
public suspend fun kubernetesCluster(
    name: String,
    block: suspend KubernetesClusterResourceBuilder.() -> Unit,
): KubernetesCluster {
    val builder = KubernetesClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [KubernetesCluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun kubernetesCluster(name: String): KubernetesCluster {
    val builder = KubernetesClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
