@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getAgentPoolPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getBareMetalMachineKeySetPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getBareMetalMachinePlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getBmcKeySetPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getCloudServicesNetworkPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getClusterManagerPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getClusterPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getConsolePlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getDefaultCniNetworkPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getHybridAksClusterPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getKubernetesClusterPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getL2NetworkPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getL3NetworkPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getMetricsConfigurationPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getRackPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getStorageAppliancePlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getTrunkedNetworkPlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getVirtualMachinePlain
import com.pulumi.azurenative.networkcloud.NetworkcloudFunctions.getVolumePlain
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetAgentPoolPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetAgentPoolPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetBareMetalMachineKeySetPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetBareMetalMachineKeySetPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetBareMetalMachinePlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetBareMetalMachinePlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetBmcKeySetPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetBmcKeySetPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetCloudServicesNetworkPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetCloudServicesNetworkPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetClusterManagerPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetClusterManagerPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetConsolePlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetConsolePlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetDefaultCniNetworkPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetDefaultCniNetworkPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetHybridAksClusterPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetHybridAksClusterPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetKubernetesClusterPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetKubernetesClusterPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetL2NetworkPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetL2NetworkPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetL3NetworkPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetL3NetworkPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetMetricsConfigurationPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetMetricsConfigurationPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetRackPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetRackPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetStorageAppliancePlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetStorageAppliancePlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetTrunkedNetworkPlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetTrunkedNetworkPlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetVirtualMachinePlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetVirtualMachinePlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetVolumePlainArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.GetVolumePlainArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetAgentPoolResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetBareMetalMachineKeySetResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetBareMetalMachineResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetBmcKeySetResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetCloudServicesNetworkResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetClusterManagerResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetClusterResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetConsoleResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetDefaultCniNetworkResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetHybridAksClusterResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetKubernetesClusterResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetL2NetworkResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetL3NetworkResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetMetricsConfigurationResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetRackResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetStorageApplianceResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetTrunkedNetworkResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetVirtualMachineResult
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetVolumeResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetAgentPoolResult.Companion.toKotlin as getAgentPoolResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetBareMetalMachineKeySetResult.Companion.toKotlin as getBareMetalMachineKeySetResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetBareMetalMachineResult.Companion.toKotlin as getBareMetalMachineResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetBmcKeySetResult.Companion.toKotlin as getBmcKeySetResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetCloudServicesNetworkResult.Companion.toKotlin as getCloudServicesNetworkResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetClusterManagerResult.Companion.toKotlin as getClusterManagerResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetConsoleResult.Companion.toKotlin as getConsoleResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetDefaultCniNetworkResult.Companion.toKotlin as getDefaultCniNetworkResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetHybridAksClusterResult.Companion.toKotlin as getHybridAksClusterResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetKubernetesClusterResult.Companion.toKotlin as getKubernetesClusterResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetL2NetworkResult.Companion.toKotlin as getL2NetworkResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetL3NetworkResult.Companion.toKotlin as getL3NetworkResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetMetricsConfigurationResult.Companion.toKotlin as getMetricsConfigurationResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetRackResult.Companion.toKotlin as getRackResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetStorageApplianceResult.Companion.toKotlin as getStorageApplianceResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetTrunkedNetworkResult.Companion.toKotlin as getTrunkedNetworkResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetVirtualMachineResult.Companion.toKotlin as getVirtualMachineResultToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.GetVolumeResult.Companion.toKotlin as getVolumeResultToKotlin

public object NetworkcloudFunctions {
    /**
     * Get properties of the provided Kubernetes cluster agent pool.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getAgentPool(argument: GetAgentPoolPlainArgs): GetAgentPoolResult =
        getAgentPoolResultToKotlin(getAgentPoolPlain(argument.toJava()).await())

    /**
     * @see [getAgentPool].
     * @param agentPoolName The name of the Kubernetes cluster agent pool.
     * @param kubernetesClusterName The name of the Kubernetes cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getAgentPool(
        agentPoolName: String,
        kubernetesClusterName: String,
        resourceGroupName: String,
    ): GetAgentPoolResult {
        val argument = GetAgentPoolPlainArgs(
            agentPoolName = agentPoolName,
            kubernetesClusterName = kubernetesClusterName,
            resourceGroupName = resourceGroupName,
        )
        return getAgentPoolResultToKotlin(getAgentPoolPlain(argument.toJava()).await())
    }

    /**
     * @see [getAgentPool].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetAgentPoolPlainArgs].
     * @return null
     */
    public suspend fun getAgentPool(argument: suspend GetAgentPoolPlainArgsBuilder.() -> Unit):
        GetAgentPoolResult {
        val builder = GetAgentPoolPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAgentPoolResultToKotlin(getAgentPoolPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided bare metal machine.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getBareMetalMachine(argument: GetBareMetalMachinePlainArgs):
        GetBareMetalMachineResult =
        getBareMetalMachineResultToKotlin(getBareMetalMachinePlain(argument.toJava()).await())

    /**
     * @see [getBareMetalMachine].
     * @param bareMetalMachineName The name of the bare metal machine.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getBareMetalMachine(bareMetalMachineName: String, resourceGroupName: String):
        GetBareMetalMachineResult {
        val argument = GetBareMetalMachinePlainArgs(
            bareMetalMachineName = bareMetalMachineName,
            resourceGroupName = resourceGroupName,
        )
        return getBareMetalMachineResultToKotlin(getBareMetalMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getBareMetalMachine].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetBareMetalMachinePlainArgs].
     * @return null
     */
    public suspend
    fun getBareMetalMachine(argument: suspend GetBareMetalMachinePlainArgsBuilder.() -> Unit):
        GetBareMetalMachineResult {
        val builder = GetBareMetalMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBareMetalMachineResultToKotlin(getBareMetalMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * Get bare metal machine key set of the provided cluster.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getBareMetalMachineKeySet(argument: GetBareMetalMachineKeySetPlainArgs):
        GetBareMetalMachineKeySetResult =
        getBareMetalMachineKeySetResultToKotlin(getBareMetalMachineKeySetPlain(argument.toJava()).await())

    /**
     * @see [getBareMetalMachineKeySet].
     * @param bareMetalMachineKeySetName The name of the bare metal machine key set.
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getBareMetalMachineKeySet(
        bareMetalMachineKeySetName: String,
        clusterName: String,
        resourceGroupName: String,
    ): GetBareMetalMachineKeySetResult {
        val argument = GetBareMetalMachineKeySetPlainArgs(
            bareMetalMachineKeySetName = bareMetalMachineKeySetName,
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getBareMetalMachineKeySetResultToKotlin(getBareMetalMachineKeySetPlain(argument.toJava()).await())
    }

    /**
     * @see [getBareMetalMachineKeySet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetBareMetalMachineKeySetPlainArgs].
     * @return null
     */
    public suspend
    fun getBareMetalMachineKeySet(argument: suspend GetBareMetalMachineKeySetPlainArgsBuilder.() -> Unit):
        GetBareMetalMachineKeySetResult {
        val builder = GetBareMetalMachineKeySetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBareMetalMachineKeySetResultToKotlin(getBareMetalMachineKeySetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get baseboard management controller key set of the provided cluster.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getBmcKeySet(argument: GetBmcKeySetPlainArgs): GetBmcKeySetResult =
        getBmcKeySetResultToKotlin(getBmcKeySetPlain(argument.toJava()).await())

    /**
     * @see [getBmcKeySet].
     * @param bmcKeySetName The name of the baseboard management controller key set.
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getBmcKeySet(
        bmcKeySetName: String,
        clusterName: String,
        resourceGroupName: String,
    ): GetBmcKeySetResult {
        val argument = GetBmcKeySetPlainArgs(
            bmcKeySetName = bmcKeySetName,
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getBmcKeySetResultToKotlin(getBmcKeySetPlain(argument.toJava()).await())
    }

    /**
     * @see [getBmcKeySet].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetBmcKeySetPlainArgs].
     * @return null
     */
    public suspend fun getBmcKeySet(argument: suspend GetBmcKeySetPlainArgsBuilder.() -> Unit):
        GetBmcKeySetResult {
        val builder = GetBmcKeySetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getBmcKeySetResultToKotlin(getBmcKeySetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided cloud services network.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return Upon creation, the additional services that are provided by the platform will be allocated and
     * represented in the status of this resource. All resources associated with this cloud services network will be part
     * of the same layer 2 (L2) isolation domain. At least one service network must be created but may be reused across many
     * virtual machines and/or Hybrid AKS clusters.
     */
    public suspend fun getCloudServicesNetwork(argument: GetCloudServicesNetworkPlainArgs):
        GetCloudServicesNetworkResult =
        getCloudServicesNetworkResultToKotlin(getCloudServicesNetworkPlain(argument.toJava()).await())

    /**
     * @see [getCloudServicesNetwork].
     * @param cloudServicesNetworkName The name of the cloud services network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Upon creation, the additional services that are provided by the platform will be allocated and
     * represented in the status of this resource. All resources associated with this cloud services network will be part
     * of the same layer 2 (L2) isolation domain. At least one service network must be created but may be reused across many
     * virtual machines and/or Hybrid AKS clusters.
     */
    public suspend fun getCloudServicesNetwork(
        cloudServicesNetworkName: String,
        resourceGroupName: String,
    ): GetCloudServicesNetworkResult {
        val argument = GetCloudServicesNetworkPlainArgs(
            cloudServicesNetworkName = cloudServicesNetworkName,
            resourceGroupName = resourceGroupName,
        )
        return getCloudServicesNetworkResultToKotlin(getCloudServicesNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getCloudServicesNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetCloudServicesNetworkPlainArgs].
     * @return Upon creation, the additional services that are provided by the platform will be allocated and
     * represented in the status of this resource. All resources associated with this cloud services network will be part
     * of the same layer 2 (L2) isolation domain. At least one service network must be created but may be reused across many
     * virtual machines and/or Hybrid AKS clusters.
     */
    public suspend
    fun getCloudServicesNetwork(argument: suspend GetCloudServicesNetworkPlainArgsBuilder.() -> Unit):
        GetCloudServicesNetworkResult {
        val builder = GetCloudServicesNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCloudServicesNetworkResultToKotlin(getCloudServicesNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided cluster.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2022-12-12-preview, 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param clusterName The name of the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getCluster(clusterName: String, resourceGroupName: String): GetClusterResult {
        val argument = GetClusterPlainArgs(
            clusterName = clusterName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return null
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit):
        GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the properties of the provided cluster manager.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getClusterManager(argument: GetClusterManagerPlainArgs):
        GetClusterManagerResult =
        getClusterManagerResultToKotlin(getClusterManagerPlain(argument.toJava()).await())

    /**
     * @see [getClusterManager].
     * @param clusterManagerName The name of the cluster manager.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getClusterManager(clusterManagerName: String, resourceGroupName: String):
        GetClusterManagerResult {
        val argument = GetClusterManagerPlainArgs(
            clusterManagerName = clusterManagerName,
            resourceGroupName = resourceGroupName,
        )
        return getClusterManagerResultToKotlin(getClusterManagerPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterManager].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetClusterManagerPlainArgs].
     * @return null
     */
    public suspend
    fun getClusterManager(argument: suspend GetClusterManagerPlainArgsBuilder.() -> Unit):
        GetClusterManagerResult {
        val builder = GetClusterManagerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterManagerResultToKotlin(getClusterManagerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided virtual machine console.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getConsole(argument: GetConsolePlainArgs): GetConsoleResult =
        getConsoleResultToKotlin(getConsolePlain(argument.toJava()).await())

    /**
     * @see [getConsole].
     * @param consoleName The name of the virtual machine console.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param virtualMachineName The name of the virtual machine.
     * @return null
     */
    public suspend fun getConsole(
        consoleName: String,
        resourceGroupName: String,
        virtualMachineName: String,
    ): GetConsoleResult {
        val argument = GetConsolePlainArgs(
            consoleName = consoleName,
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getConsoleResultToKotlin(getConsolePlain(argument.toJava()).await())
    }

    /**
     * @see [getConsole].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetConsolePlainArgs].
     * @return null
     */
    public suspend fun getConsole(argument: suspend GetConsolePlainArgsBuilder.() -> Unit):
        GetConsoleResult {
        val builder = GetConsolePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConsoleResultToKotlin(getConsolePlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided default CNI network.
     * Azure REST API version: 2022-12-12-preview.
     * @param argument null
     * @return null
     */
    public suspend fun getDefaultCniNetwork(argument: GetDefaultCniNetworkPlainArgs):
        GetDefaultCniNetworkResult =
        getDefaultCniNetworkResultToKotlin(getDefaultCniNetworkPlain(argument.toJava()).await())

    /**
     * @see [getDefaultCniNetwork].
     * @param defaultCniNetworkName The name of the default CNI network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getDefaultCniNetwork(defaultCniNetworkName: String, resourceGroupName: String):
        GetDefaultCniNetworkResult {
        val argument = GetDefaultCniNetworkPlainArgs(
            defaultCniNetworkName = defaultCniNetworkName,
            resourceGroupName = resourceGroupName,
        )
        return getDefaultCniNetworkResultToKotlin(getDefaultCniNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getDefaultCniNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetDefaultCniNetworkPlainArgs].
     * @return null
     */
    public suspend
    fun getDefaultCniNetwork(argument: suspend GetDefaultCniNetworkPlainArgsBuilder.() -> Unit):
        GetDefaultCniNetworkResult {
        val builder = GetDefaultCniNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDefaultCniNetworkResultToKotlin(getDefaultCniNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Get the additional details related to the provided Hybrid AKS provisioned cluster.
     * Azure REST API version: 2022-12-12-preview.
     * @param argument null
     * @return The details are specific to the Network Cloud use of the Hybrid AKS cluster.
     */
    public suspend fun getHybridAksCluster(argument: GetHybridAksClusterPlainArgs):
        GetHybridAksClusterResult =
        getHybridAksClusterResultToKotlin(getHybridAksClusterPlain(argument.toJava()).await())

    /**
     * @see [getHybridAksCluster].
     * @param hybridAksClusterName The name of the Hybrid AKS cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The details are specific to the Network Cloud use of the Hybrid AKS cluster.
     */
    public suspend fun getHybridAksCluster(hybridAksClusterName: String, resourceGroupName: String):
        GetHybridAksClusterResult {
        val argument = GetHybridAksClusterPlainArgs(
            hybridAksClusterName = hybridAksClusterName,
            resourceGroupName = resourceGroupName,
        )
        return getHybridAksClusterResultToKotlin(getHybridAksClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getHybridAksCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetHybridAksClusterPlainArgs].
     * @return The details are specific to the Network Cloud use of the Hybrid AKS cluster.
     */
    public suspend
    fun getHybridAksCluster(argument: suspend GetHybridAksClusterPlainArgsBuilder.() -> Unit):
        GetHybridAksClusterResult {
        val builder = GetHybridAksClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getHybridAksClusterResultToKotlin(getHybridAksClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided the Kubernetes cluster.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getKubernetesCluster(argument: GetKubernetesClusterPlainArgs):
        GetKubernetesClusterResult =
        getKubernetesClusterResultToKotlin(getKubernetesClusterPlain(argument.toJava()).await())

    /**
     * @see [getKubernetesCluster].
     * @param kubernetesClusterName The name of the Kubernetes cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getKubernetesCluster(kubernetesClusterName: String, resourceGroupName: String):
        GetKubernetesClusterResult {
        val argument = GetKubernetesClusterPlainArgs(
            kubernetesClusterName = kubernetesClusterName,
            resourceGroupName = resourceGroupName,
        )
        return getKubernetesClusterResultToKotlin(getKubernetesClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getKubernetesCluster].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetKubernetesClusterPlainArgs].
     * @return null
     */
    public suspend
    fun getKubernetesCluster(argument: suspend GetKubernetesClusterPlainArgsBuilder.() -> Unit):
        GetKubernetesClusterResult {
        val builder = GetKubernetesClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getKubernetesClusterResultToKotlin(getKubernetesClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided layer 2 (L2) network.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getL2Network(argument: GetL2NetworkPlainArgs): GetL2NetworkResult =
        getL2NetworkResultToKotlin(getL2NetworkPlain(argument.toJava()).await())

    /**
     * @see [getL2Network].
     * @param l2NetworkName The name of the L2 network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getL2Network(l2NetworkName: String, resourceGroupName: String):
        GetL2NetworkResult {
        val argument = GetL2NetworkPlainArgs(
            l2NetworkName = l2NetworkName,
            resourceGroupName = resourceGroupName,
        )
        return getL2NetworkResultToKotlin(getL2NetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getL2Network].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetL2NetworkPlainArgs].
     * @return null
     */
    public suspend fun getL2Network(argument: suspend GetL2NetworkPlainArgsBuilder.() -> Unit):
        GetL2NetworkResult {
        val builder = GetL2NetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getL2NetworkResultToKotlin(getL2NetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided layer 3 (L3) network.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getL3Network(argument: GetL3NetworkPlainArgs): GetL3NetworkResult =
        getL3NetworkResultToKotlin(getL3NetworkPlain(argument.toJava()).await())

    /**
     * @see [getL3Network].
     * @param l3NetworkName The name of the L3 network.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getL3Network(l3NetworkName: String, resourceGroupName: String):
        GetL3NetworkResult {
        val argument = GetL3NetworkPlainArgs(
            l3NetworkName = l3NetworkName,
            resourceGroupName = resourceGroupName,
        )
        return getL3NetworkResultToKotlin(getL3NetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getL3Network].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetL3NetworkPlainArgs].
     * @return null
     */
    public suspend fun getL3Network(argument: suspend GetL3NetworkPlainArgsBuilder.() -> Unit):
        GetL3NetworkResult {
        val builder = GetL3NetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getL3NetworkResultToKotlin(getL3NetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Get metrics configuration of the provided cluster.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getMetricsConfiguration(argument: GetMetricsConfigurationPlainArgs):
        GetMetricsConfigurationResult =
        getMetricsConfigurationResultToKotlin(getMetricsConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getMetricsConfiguration].
     * @param clusterName The name of the cluster.
     * @param metricsConfigurationName The name of the metrics configuration for the cluster.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getMetricsConfiguration(
        clusterName: String,
        metricsConfigurationName: String,
        resourceGroupName: String,
    ): GetMetricsConfigurationResult {
        val argument = GetMetricsConfigurationPlainArgs(
            clusterName = clusterName,
            metricsConfigurationName = metricsConfigurationName,
            resourceGroupName = resourceGroupName,
        )
        return getMetricsConfigurationResultToKotlin(getMetricsConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getMetricsConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetMetricsConfigurationPlainArgs].
     * @return null
     */
    public suspend
    fun getMetricsConfiguration(argument: suspend GetMetricsConfigurationPlainArgsBuilder.() -> Unit):
        GetMetricsConfigurationResult {
        val builder = GetMetricsConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getMetricsConfigurationResultToKotlin(getMetricsConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided rack.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getRack(argument: GetRackPlainArgs): GetRackResult =
        getRackResultToKotlin(getRackPlain(argument.toJava()).await())

    /**
     * @see [getRack].
     * @param rackName The name of the rack.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return null
     */
    public suspend fun getRack(rackName: String, resourceGroupName: String): GetRackResult {
        val argument = GetRackPlainArgs(
            rackName = rackName,
            resourceGroupName = resourceGroupName,
        )
        return getRackResultToKotlin(getRackPlain(argument.toJava()).await())
    }

    /**
     * @see [getRack].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetRackPlainArgs].
     * @return null
     */
    public suspend fun getRack(argument: suspend GetRackPlainArgsBuilder.() -> Unit): GetRackResult {
        val builder = GetRackPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRackResultToKotlin(getRackPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided storage appliance.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getStorageAppliance(argument: GetStorageAppliancePlainArgs):
        GetStorageApplianceResult =
        getStorageApplianceResultToKotlin(getStorageAppliancePlain(argument.toJava()).await())

    /**
     * @see [getStorageAppliance].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param storageApplianceName The name of the storage appliance.
     * @return null
     */
    public suspend fun getStorageAppliance(resourceGroupName: String, storageApplianceName: String):
        GetStorageApplianceResult {
        val argument = GetStorageAppliancePlainArgs(
            resourceGroupName = resourceGroupName,
            storageApplianceName = storageApplianceName,
        )
        return getStorageApplianceResultToKotlin(getStorageAppliancePlain(argument.toJava()).await())
    }

    /**
     * @see [getStorageAppliance].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetStorageAppliancePlainArgs].
     * @return null
     */
    public suspend
    fun getStorageAppliance(argument: suspend GetStorageAppliancePlainArgsBuilder.() -> Unit):
        GetStorageApplianceResult {
        val builder = GetStorageAppliancePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStorageApplianceResultToKotlin(getStorageAppliancePlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided trunked network.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getTrunkedNetwork(argument: GetTrunkedNetworkPlainArgs):
        GetTrunkedNetworkResult =
        getTrunkedNetworkResultToKotlin(getTrunkedNetworkPlain(argument.toJava()).await())

    /**
     * @see [getTrunkedNetwork].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param trunkedNetworkName The name of the trunked network.
     * @return null
     */
    public suspend fun getTrunkedNetwork(resourceGroupName: String, trunkedNetworkName: String):
        GetTrunkedNetworkResult {
        val argument = GetTrunkedNetworkPlainArgs(
            resourceGroupName = resourceGroupName,
            trunkedNetworkName = trunkedNetworkName,
        )
        return getTrunkedNetworkResultToKotlin(getTrunkedNetworkPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrunkedNetwork].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetTrunkedNetworkPlainArgs].
     * @return null
     */
    public suspend
    fun getTrunkedNetwork(argument: suspend GetTrunkedNetworkPlainArgsBuilder.() -> Unit):
        GetTrunkedNetworkResult {
        val builder = GetTrunkedNetworkPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTrunkedNetworkResultToKotlin(getTrunkedNetworkPlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided virtual machine.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getVirtualMachine(argument: GetVirtualMachinePlainArgs):
        GetVirtualMachineResult =
        getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())

    /**
     * @see [getVirtualMachine].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param virtualMachineName The name of the virtual machine.
     * @return null
     */
    public suspend fun getVirtualMachine(resourceGroupName: String, virtualMachineName: String):
        GetVirtualMachineResult {
        val argument = GetVirtualMachinePlainArgs(
            resourceGroupName = resourceGroupName,
            virtualMachineName = virtualMachineName,
        )
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(argument.toJava()).await())
    }

    /**
     * @see [getVirtualMachine].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetVirtualMachinePlainArgs].
     * @return null
     */
    public suspend
    fun getVirtualMachine(argument: suspend GetVirtualMachinePlainArgsBuilder.() -> Unit):
        GetVirtualMachineResult {
        val builder = GetVirtualMachinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVirtualMachineResultToKotlin(getVirtualMachinePlain(builtArgument.toJava()).await())
    }

    /**
     * Get properties of the provided volume.
     * Azure REST API version: 2023-05-01-preview.
     * Other available API versions: 2023-07-01.
     * @param argument null
     * @return null
     */
    public suspend fun getVolume(argument: GetVolumePlainArgs): GetVolumeResult =
        getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())

    /**
     * @see [getVolume].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param volumeName The name of the volume.
     * @return null
     */
    public suspend fun getVolume(resourceGroupName: String, volumeName: String): GetVolumeResult {
        val argument = GetVolumePlainArgs(
            resourceGroupName = resourceGroupName,
            volumeName = volumeName,
        )
        return getVolumeResultToKotlin(getVolumePlain(argument.toJava()).await())
    }

    /**
     * @see [getVolume].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;networkcloud&#46;kotlin&#46;inputs&#46;GetVolumePlainArgs].
     * @return null
     */
    public suspend fun getVolume(argument: suspend GetVolumePlainArgsBuilder.() -> Unit):
        GetVolumeResult {
        val builder = GetVolumePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getVolumeResultToKotlin(getVolumePlain(builtArgument.toJava()).await())
    }
}
