@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.StorageApplianceArgs.builder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AdministrativeCredentialsArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.AdministrativeCredentialsArgsBuilder
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgs
import com.pulumi.azurenative.networkcloud.kotlin.inputs.ExtendedLocationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update storage appliance
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var storageAppliance = new AzureNative.NetworkCloud.StorageAppliance("storageAppliance", new()
 *     {
 *         AdministratorCredentials = new AzureNative.NetworkCloud.Inputs.AdministrativeCredentialsArgs
 *         {
 *             Password = "{password}",
 *             Username = "adminUser",
 *         },
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         Location = "location",
 *         RackId = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName",
 *         RackSlot = 1,
 *         ResourceGroupName = "resourceGroupName",
 *         SerialNumber = "BM1219XXX",
 *         StorageApplianceName = "storageApplianceName",
 *         StorageApplianceSkuId = "684E-3B16-399E",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewStorageAppliance(ctx, "storageAppliance", &networkcloud.StorageApplianceArgs{
 * 			AdministratorCredentials: &networkcloud.AdministrativeCredentialsArgs{
 * 				Password: pulumi.String("{password}"),
 * 				Username: pulumi.String("adminUser"),
 * 			},
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:              pulumi.String("location"),
 * 			RackId:                pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName"),
 * 			RackSlot:              pulumi.Float64(1),
 * 			ResourceGroupName:     pulumi.String("resourceGroupName"),
 * 			SerialNumber:          pulumi.String("BM1219XXX"),
 * 			StorageApplianceName:  pulumi.String("storageApplianceName"),
 * 			StorageApplianceSkuId: pulumi.String("684E-3B16-399E"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.StorageAppliance;
 * import com.pulumi.azurenative.networkcloud.StorageApplianceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var storageAppliance = new StorageAppliance("storageAppliance", StorageApplianceArgs.builder()
 *             .administratorCredentials(Map.ofEntries(
 *                 Map.entry("password", "{password}"),
 *                 Map.entry("username", "adminUser")
 *             ))
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("location")
 *             .rackId("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.NetworkCloud/racks/rackName")
 *             .rackSlot(1)
 *             .resourceGroupName("resourceGroupName")
 *             .serialNumber("BM1219XXX")
 *             .storageApplianceName("storageApplianceName")
 *             .storageApplianceSkuId("684E-3B16-399E")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:StorageAppliance storageApplianceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/storageAppliances/{storageApplianceName}
 * ```
 * @property administratorCredentials The credentials of the administrative interface on this storage appliance.
 * @property extendedLocation The extended location of the cluster associated with the resource.
 * @property location The geo-location where the resource lives
 * @property rackId The resource ID of the rack where this storage appliance resides.
 * @property rackSlot The slot the storage appliance is in the rack based on the BOM configuration.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serialNumber The serial number for the storage appliance.
 * @property storageApplianceName The name of the storage appliance.
 * @property storageApplianceSkuId The SKU for the storage appliance.
 * @property tags Resource tags.
 */
public data class StorageApplianceArgs(
    public val administratorCredentials: Output<AdministrativeCredentialsArgs>? = null,
    public val extendedLocation: Output<ExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val rackId: Output<String>? = null,
    public val rackSlot: Output<Double>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serialNumber: Output<String>? = null,
    public val storageApplianceName: Output<String>? = null,
    public val storageApplianceSkuId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.StorageApplianceArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.StorageApplianceArgs =
        com.pulumi.azurenative.networkcloud.StorageApplianceArgs.builder()
            .administratorCredentials(
                administratorCredentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .rackId(rackId?.applyValue({ args0 -> args0 }))
            .rackSlot(rackSlot?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serialNumber(serialNumber?.applyValue({ args0 -> args0 }))
            .storageApplianceName(storageApplianceName?.applyValue({ args0 -> args0 }))
            .storageApplianceSkuId(storageApplianceSkuId?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StorageApplianceArgs].
 */
@PulumiTagMarker
public class StorageApplianceArgsBuilder internal constructor() {
    private var administratorCredentials: Output<AdministrativeCredentialsArgs>? = null

    private var extendedLocation: Output<ExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var rackId: Output<String>? = null

    private var rackSlot: Output<Double>? = null

    private var resourceGroupName: Output<String>? = null

    private var serialNumber: Output<String>? = null

    private var storageApplianceName: Output<String>? = null

    private var storageApplianceSkuId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The credentials of the administrative interface on this storage appliance.
     */
    @JvmName("uifsqhqqgdopgkan")
    public suspend fun administratorCredentials(`value`: Output<AdministrativeCredentialsArgs>) {
        this.administratorCredentials = value
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("rujlsjqnxnwjbwar")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("wvqxsrailmerjjvt")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The resource ID of the rack where this storage appliance resides.
     */
    @JvmName("retwxlwkfwhkgmne")
    public suspend fun rackId(`value`: Output<String>) {
        this.rackId = value
    }

    /**
     * @param value The slot the storage appliance is in the rack based on the BOM configuration.
     */
    @JvmName("vaemykikuoxurqad")
    public suspend fun rackSlot(`value`: Output<Double>) {
        this.rackSlot = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("tvtyoptnfobsrehk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The serial number for the storage appliance.
     */
    @JvmName("gqhshvqxvbbeodkg")
    public suspend fun serialNumber(`value`: Output<String>) {
        this.serialNumber = value
    }

    /**
     * @param value The name of the storage appliance.
     */
    @JvmName("nycyxmwcfcvnvwxx")
    public suspend fun storageApplianceName(`value`: Output<String>) {
        this.storageApplianceName = value
    }

    /**
     * @param value The SKU for the storage appliance.
     */
    @JvmName("vxkmtraktvsfxril")
    public suspend fun storageApplianceSkuId(`value`: Output<String>) {
        this.storageApplianceSkuId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hnbcjdcfkfbfvpjl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The credentials of the administrative interface on this storage appliance.
     */
    @JvmName("iifogrpowpuhnpep")
    public suspend fun administratorCredentials(`value`: AdministrativeCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorCredentials = mapped
    }

    /**
     * @param argument The credentials of the administrative interface on this storage appliance.
     */
    @JvmName("ecpegoenynkgbbeh")
    public suspend
    fun administratorCredentials(argument: suspend AdministrativeCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = AdministrativeCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.administratorCredentials = mapped
    }

    /**
     * @param value The extended location of the cluster associated with the resource.
     */
    @JvmName("lcsafblxsohbxevm")
    public suspend fun extendedLocation(`value`: ExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location of the cluster associated with the resource.
     */
    @JvmName("fcthfshqsqlpkrua")
    public suspend fun extendedLocation(argument: suspend ExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xumoplwmybbnmmfy")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The resource ID of the rack where this storage appliance resides.
     */
    @JvmName("ttfsnrgwhbpchbqg")
    public suspend fun rackId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rackId = mapped
    }

    /**
     * @param value The slot the storage appliance is in the rack based on the BOM configuration.
     */
    @JvmName("uqifqoykdknpcorq")
    public suspend fun rackSlot(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rackSlot = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ggmkoikgdccqeenm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The serial number for the storage appliance.
     */
    @JvmName("ddhypuunonemrerk")
    public suspend fun serialNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serialNumber = mapped
    }

    /**
     * @param value The name of the storage appliance.
     */
    @JvmName("bagmhjfpsubacwxb")
    public suspend fun storageApplianceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageApplianceName = mapped
    }

    /**
     * @param value The SKU for the storage appliance.
     */
    @JvmName("rmpyehtrswwuodkn")
    public suspend fun storageApplianceSkuId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageApplianceSkuId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("grnxfwxqtysuangt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gktamawqqqlndtlj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StorageApplianceArgs = StorageApplianceArgs(
        administratorCredentials = administratorCredentials,
        extendedLocation = extendedLocation,
        location = location,
        rackId = rackId,
        rackSlot = rackSlot,
        resourceGroupName = resourceGroupName,
        serialNumber = serialNumber,
        storageApplianceName = storageApplianceName,
        storageApplianceSkuId = storageApplianceSkuId,
        tags = tags,
    )
}
