@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin

import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin as extendedLocationResponseToKotlin
import com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [TrunkedNetwork].
 */
@PulumiTagMarker
public class TrunkedNetworkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrunkedNetworkArgs = TrunkedNetworkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrunkedNetworkArgsBuilder.() -> Unit) {
        val builder = TrunkedNetworkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): TrunkedNetwork {
        val builtJavaResource =
            com.pulumi.azurenative.networkcloud.TrunkedNetwork(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return TrunkedNetwork(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2023-05-01-preview. Prior API version in Azure Native 1.x: 2022-12-12-preview.
 * Other available API versions: 2023-07-01.
 * ## Example Usage
 * ### Create or update trunked network
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trunkedNetwork = new AzureNative.NetworkCloud.TrunkedNetwork("trunkedNetwork", new()
 *     {
 *         ExtendedLocation = new AzureNative.NetworkCloud.Inputs.ExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName",
 *             Type = "CustomLocation",
 *         },
 *         InterfaceName = "eth0",
 *         IsolationDomainIds = new[]
 *         {
 *             "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l2IsolationDomains/l2IsolationDomainName",
 *             "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName",
 *         },
 *         Location = "location",
 *         ResourceGroupName = "resourceGroupName",
 *         Tags =
 *         {
 *             { "key1", "myvalue1" },
 *             { "key2", "myvalue2" },
 *         },
 *         TrunkedNetworkName = "trunkedNetworkName",
 *         Vlans = new[]
 *         {
 *             12,
 *             14,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkcloud/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkcloud.NewTrunkedNetwork(ctx, "trunkedNetwork", &networkcloud.TrunkedNetworkArgs{
 * 			ExtendedLocation: &networkcloud.ExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			InterfaceName: pulumi.String("eth0"),
 * 			IsolationDomainIds: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l2IsolationDomains/l2IsolationDomainName"),
 * 				pulumi.String("/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName"),
 * 			},
 * 			Location:          pulumi.String("location"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("myvalue1"),
 * 				"key2": pulumi.String("myvalue2"),
 * 			},
 * 			TrunkedNetworkName: pulumi.String("trunkedNetworkName"),
 * 			Vlans: pulumi.Float64Array{
 * 				pulumi.Float64(12),
 * 				pulumi.Float64(14),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkcloud.TrunkedNetwork;
 * import com.pulumi.azurenative.networkcloud.TrunkedNetworkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trunkedNetwork = new TrunkedNetwork("trunkedNetwork", TrunkedNetworkArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ExtendedLocation/customLocations/clusterExtendedLocationName"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .interfaceName("eth0")
 *             .isolationDomainIds(
 *                 "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l2IsolationDomains/l2IsolationDomainName",
 *                 "/subscriptions/123e4567-e89b-12d3-a456-426655440000/resourceGroups/resourceGroupName/providers/Microsoft.ManagedNetworkFabric/l3IsolationDomains/l3IsolationDomainName")
 *             .location("location")
 *             .resourceGroupName("resourceGroupName")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "myvalue1"),
 *                 Map.entry("key2", "myvalue2")
 *             ))
 *             .trunkedNetworkName("trunkedNetworkName")
 *             .vlans(
 *                 12,
 *                 14)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkcloud:TrunkedNetwork trunkedNetworkName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/trunkedNetworks/{trunkedNetworkName}
 * ```
 */
public class TrunkedNetwork internal constructor(
    override val javaResource: com.pulumi.azurenative.networkcloud.TrunkedNetwork,
) : KotlinCustomResource(javaResource, TrunkedNetworkMapper) {
    /**
     * The list of resource IDs for the other Microsoft.NetworkCloud resources that have attached this network.
     */
    public val associatedResourceIds: Output<List<String>>
        get() = javaResource.associatedResourceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The resource ID of the Network Cloud cluster this trunked network is associated with.
     */
    public val clusterId: Output<String>
        get() = javaResource.clusterId().applyValue({ args0 -> args0 })

    /**
     * The more detailed status of the trunked network.
     */
    public val detailedStatus: Output<String>
        get() = javaResource.detailedStatus().applyValue({ args0 -> args0 })

    /**
     * The descriptive message about the current detailed status.
     */
    public val detailedStatusMessage: Output<String>
        get() = javaResource.detailedStatusMessage().applyValue({ args0 -> args0 })

    /**
     * The extended location of the cluster associated with the resource.
     */
    public val extendedLocation: Output<ExtendedLocationResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationResponseToKotlin(args0)
            })
        })

    /**
     * Field Deprecated. These fields will be empty/omitted. The list of Hybrid AKS cluster resource IDs that are associated with this trunked network.
     */
    public val hybridAksClustersAssociatedIds: Output<List<String>>
        get() = javaResource.hybridAksClustersAssociatedIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Field Deprecated. The field was previously optional, now it will have no defined behavior and will be ignored. The network plugin type for Hybrid AKS.
     */
    public val hybridAksPluginType: Output<String>?
        get() = javaResource.hybridAksPluginType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The default interface name for this trunked network in the virtual machine. This name can be overridden by the name supplied in the network attachment configuration of that virtual machine.
     */
    public val interfaceName: Output<String>?
        get() = javaResource.interfaceName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The list of resource IDs representing the Network Fabric isolation domains. It can be any combination of l2IsolationDomain and l3IsolationDomain resources.
     */
    public val isolationDomainIds: Output<List<String>>
        get() = javaResource.isolationDomainIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the trunked network.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Field Deprecated. These fields will be empty/omitted. The list of virtual machine resource IDs, excluding any Hybrid AKS virtual machines, that are currently using this trunked network.
     */
    public val virtualMachinesAssociatedIds: Output<List<String>>
        get() = javaResource.virtualMachinesAssociatedIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * The list of vlans that are selected from the isolation domains for trunking.
     */
    public val vlans: Output<List<Double>>
        get() = javaResource.vlans().applyValue({ args0 -> args0.map({ args0 -> args0 }) })
}

public object TrunkedNetworkMapper : ResourceMapper<TrunkedNetwork> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkcloud.TrunkedNetwork::class == javaResource::class

    override fun map(javaResource: Resource): TrunkedNetwork = TrunkedNetwork(
        javaResource as
            com.pulumi.azurenative.networkcloud.TrunkedNetwork,
    )
}

/**
 * @see [TrunkedNetwork].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrunkedNetwork].
 */
public suspend fun trunkedNetwork(
    name: String,
    block: suspend TrunkedNetworkResourceBuilder.() -> Unit,
): TrunkedNetwork {
    val builder = TrunkedNetworkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrunkedNetwork].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trunkedNetwork(name: String): TrunkedNetwork {
    val builder = TrunkedNetworkResourceBuilder()
    builder.name(name)
    return builder.build()
}
