@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The type of rack configuration for the cluster.
 */
public enum class ClusterType(
    public val javaValue: com.pulumi.azurenative.networkcloud.enums.ClusterType,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.enums.ClusterType> {
    SingleRack(com.pulumi.azurenative.networkcloud.enums.ClusterType.SingleRack),
    MultiRack(com.pulumi.azurenative.networkcloud.enums.ClusterType.MultiRack),
    ;

    override fun toJava(): com.pulumi.azurenative.networkcloud.enums.ClusterType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.enums.ClusterType):
            ClusterType = ClusterType.values().first { it.javaValue == javaType }
    }
}
