@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The indicator of how this network will be utilized by the Kubernetes cluster.
 */
public enum class KubernetesPluginType(
    public val javaValue: com.pulumi.azurenative.networkcloud.enums.KubernetesPluginType,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.enums.KubernetesPluginType> {
    DPDK(com.pulumi.azurenative.networkcloud.enums.KubernetesPluginType.DPDK),
    SRIOV(com.pulumi.azurenative.networkcloud.enums.KubernetesPluginType.SRIOV),
    OSDevice(com.pulumi.azurenative.networkcloud.enums.KubernetesPluginType.OSDevice),
    MACVLAN(com.pulumi.azurenative.networkcloud.enums.KubernetesPluginType.MACVLAN),
    IPVLAN(com.pulumi.azurenative.networkcloud.enums.KubernetesPluginType.IPVLAN),
    ;

    override fun toJava(): com.pulumi.azurenative.networkcloud.enums.KubernetesPluginType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.enums.KubernetesPluginType):
            KubernetesPluginType = KubernetesPluginType.values().first { it.javaValue == javaType }
    }
}
