@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.AadConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property adminGroupObjectIds The list of Azure Active Directory group object IDs that will have an administrative role on the Kubernetes cluster.
 */
public data class AadConfigurationArgs(
    public val adminGroupObjectIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.AadConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.AadConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.AadConfigurationArgs.builder()
            .adminGroupObjectIds(
                adminGroupObjectIds.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [AadConfigurationArgs].
 */
@PulumiTagMarker
public class AadConfigurationArgsBuilder internal constructor() {
    private var adminGroupObjectIds: Output<List<String>>? = null

    /**
     * @param value The list of Azure Active Directory group object IDs that will have an administrative role on the Kubernetes cluster.
     */
    @JvmName("tfvjlrfatbjksdhu")
    public suspend fun adminGroupObjectIds(`value`: Output<List<String>>) {
        this.adminGroupObjectIds = value
    }

    @JvmName("xdbecuikmobblfcq")
    public suspend fun adminGroupObjectIds(vararg values: Output<String>) {
        this.adminGroupObjectIds = Output.all(values.asList())
    }

    /**
     * @param values The list of Azure Active Directory group object IDs that will have an administrative role on the Kubernetes cluster.
     */
    @JvmName("nusqcmepbsffywqd")
    public suspend fun adminGroupObjectIds(values: List<Output<String>>) {
        this.adminGroupObjectIds = Output.all(values)
    }

    /**
     * @param value The list of Azure Active Directory group object IDs that will have an administrative role on the Kubernetes cluster.
     */
    @JvmName("ejtknccyfpdadjcg")
    public suspend fun adminGroupObjectIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminGroupObjectIds = mapped
    }

    /**
     * @param values The list of Azure Active Directory group object IDs that will have an administrative role on the Kubernetes cluster.
     */
    @JvmName("jpxmttvsbahxgyro")
    public suspend fun adminGroupObjectIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminGroupObjectIds = mapped
    }

    internal fun build(): AadConfigurationArgs = AadConfigurationArgs(
        adminGroupObjectIds = adminGroupObjectIds ?: throw PulumiNullFieldException("adminGroupObjectIds"),
    )
}
