@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.BgpPeerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property asNumber The ASN (Autonomous System Number) of the BGP peer.
 * @property password The password for this peering neighbor. It defaults to no password if not specified.
 * @property peerIp The IPv4 or IPv6 address to peer with the associated CNI Network. The IP version type will drive a peering with the same version type from the Default CNI Network. For example, IPv4 to IPv4 or IPv6 to IPv6.
 */
public data class BgpPeerArgs(
    public val asNumber: Output<Double>,
    public val password: Output<String>? = null,
    public val peerIp: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.BgpPeerArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.BgpPeerArgs =
        com.pulumi.azurenative.networkcloud.inputs.BgpPeerArgs.builder()
            .asNumber(asNumber.applyValue({ args0 -> args0 }))
            .password(password?.applyValue({ args0 -> args0 }))
            .peerIp(peerIp.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BgpPeerArgs].
 */
@PulumiTagMarker
public class BgpPeerArgsBuilder internal constructor() {
    private var asNumber: Output<Double>? = null

    private var password: Output<String>? = null

    private var peerIp: Output<String>? = null

    /**
     * @param value The ASN (Autonomous System Number) of the BGP peer.
     */
    @JvmName("aoaoeggkbvjkaiik")
    public suspend fun asNumber(`value`: Output<Double>) {
        this.asNumber = value
    }

    /**
     * @param value The password for this peering neighbor. It defaults to no password if not specified.
     */
    @JvmName("cjsjudsnratuqgmb")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The IPv4 or IPv6 address to peer with the associated CNI Network. The IP version type will drive a peering with the same version type from the Default CNI Network. For example, IPv4 to IPv4 or IPv6 to IPv6.
     */
    @JvmName("xsaxjogwqyekotis")
    public suspend fun peerIp(`value`: Output<String>) {
        this.peerIp = value
    }

    /**
     * @param value The ASN (Autonomous System Number) of the BGP peer.
     */
    @JvmName("gosjpmrmqonplapg")
    public suspend fun asNumber(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.asNumber = mapped
    }

    /**
     * @param value The password for this peering neighbor. It defaults to no password if not specified.
     */
    @JvmName("fymslmpcanqpbvjt")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The IPv4 or IPv6 address to peer with the associated CNI Network. The IP version type will drive a peering with the same version type from the Default CNI Network. For example, IPv4 to IPv4 or IPv6 to IPv6.
     */
    @JvmName("osgcxvfbaceohckr")
    public suspend fun peerIp(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.peerIp = mapped
    }

    internal fun build(): BgpPeerArgs = BgpPeerArgs(
        asNumber = asNumber ?: throw PulumiNullFieldException("asNumber"),
        password = password,
        peerIp = peerIp ?: throw PulumiNullFieldException("peerIp"),
    )
}
