@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.CniBgpConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bgpPeers The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
 * @property communityAdvertisements The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
 * communities that should be associated with that prefix when it is announced.
 * @property nodeMeshPassword The password of the Calico node mesh. It defaults to a randomly-generated string when not provided.
 * @property serviceExternalPrefixes The subnet blocks in CIDR format for Kubernetes service external IPs to be advertised over BGP.
 * @property serviceLoadBalancerPrefixes The subnet blocks in CIDR format for Kubernetes load balancers. Load balancer IPs will only be advertised if they
 * are within one of these blocks.
 */
public data class CniBgpConfigurationArgs(
    public val bgpPeers: Output<List<BgpPeerArgs>>? = null,
    public val communityAdvertisements: Output<List<CommunityAdvertisementArgs>>? = null,
    public val nodeMeshPassword: Output<String>? = null,
    public val serviceExternalPrefixes: Output<List<String>>? = null,
    public val serviceLoadBalancerPrefixes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.CniBgpConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.CniBgpConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.CniBgpConfigurationArgs.builder()
            .bgpPeers(
                bgpPeers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .communityAdvertisements(
                communityAdvertisements?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .nodeMeshPassword(nodeMeshPassword?.applyValue({ args0 -> args0 }))
            .serviceExternalPrefixes(
                serviceExternalPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .serviceLoadBalancerPrefixes(
                serviceLoadBalancerPrefixes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [CniBgpConfigurationArgs].
 */
@PulumiTagMarker
public class CniBgpConfigurationArgsBuilder internal constructor() {
    private var bgpPeers: Output<List<BgpPeerArgs>>? = null

    private var communityAdvertisements: Output<List<CommunityAdvertisementArgs>>? = null

    private var nodeMeshPassword: Output<String>? = null

    private var serviceExternalPrefixes: Output<List<String>>? = null

    private var serviceLoadBalancerPrefixes: Output<List<String>>? = null

    /**
     * @param value The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
     */
    @JvmName("srodmmwapjaaiwra")
    public suspend fun bgpPeers(`value`: Output<List<BgpPeerArgs>>) {
        this.bgpPeers = value
    }

    @JvmName("okalixadfrrptedr")
    public suspend fun bgpPeers(vararg values: Output<BgpPeerArgs>) {
        this.bgpPeers = Output.all(values.asList())
    }

    /**
     * @param values The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
     */
    @JvmName("ovdqdcjcuvsnpcsy")
    public suspend fun bgpPeers(values: List<Output<BgpPeerArgs>>) {
        this.bgpPeers = Output.all(values)
    }

    /**
     * @param value The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
     * communities that should be associated with that prefix when it is announced.
     */
    @JvmName("ccgdbxcpsoifwmqx")
    public suspend fun communityAdvertisements(`value`: Output<List<CommunityAdvertisementArgs>>) {
        this.communityAdvertisements = value
    }

    @JvmName("onghaidomcyamiav")
    public suspend fun communityAdvertisements(vararg values: Output<CommunityAdvertisementArgs>) {
        this.communityAdvertisements = Output.all(values.asList())
    }

    /**
     * @param values The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
     * communities that should be associated with that prefix when it is announced.
     */
    @JvmName("hqbhhjifqihfqmhk")
    public suspend fun communityAdvertisements(values: List<Output<CommunityAdvertisementArgs>>) {
        this.communityAdvertisements = Output.all(values)
    }

    /**
     * @param value The password of the Calico node mesh. It defaults to a randomly-generated string when not provided.
     */
    @JvmName("kolpnssdnvkfamta")
    public suspend fun nodeMeshPassword(`value`: Output<String>) {
        this.nodeMeshPassword = value
    }

    /**
     * @param value The subnet blocks in CIDR format for Kubernetes service external IPs to be advertised over BGP.
     */
    @JvmName("puxxhleseggcyttc")
    public suspend fun serviceExternalPrefixes(`value`: Output<List<String>>) {
        this.serviceExternalPrefixes = value
    }

    @JvmName("jikujtpibyxdenkj")
    public suspend fun serviceExternalPrefixes(vararg values: Output<String>) {
        this.serviceExternalPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The subnet blocks in CIDR format for Kubernetes service external IPs to be advertised over BGP.
     */
    @JvmName("qhkxhhupddtrjxcf")
    public suspend fun serviceExternalPrefixes(values: List<Output<String>>) {
        this.serviceExternalPrefixes = Output.all(values)
    }

    /**
     * @param value The subnet blocks in CIDR format for Kubernetes load balancers. Load balancer IPs will only be advertised if they
     * are within one of these blocks.
     */
    @JvmName("fiwqtotmlgnvrqeb")
    public suspend fun serviceLoadBalancerPrefixes(`value`: Output<List<String>>) {
        this.serviceLoadBalancerPrefixes = value
    }

    @JvmName("vymqxcfytqofsoeq")
    public suspend fun serviceLoadBalancerPrefixes(vararg values: Output<String>) {
        this.serviceLoadBalancerPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The subnet blocks in CIDR format for Kubernetes load balancers. Load balancer IPs will only be advertised if they
     * are within one of these blocks.
     */
    @JvmName("bxhxqjdphwckinjh")
    public suspend fun serviceLoadBalancerPrefixes(values: List<Output<String>>) {
        this.serviceLoadBalancerPrefixes = Output.all(values)
    }

    /**
     * @param value The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
     */
    @JvmName("evwsheapuvkyndoo")
    public suspend fun bgpPeers(`value`: List<BgpPeerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bgpPeers = mapped
    }

    /**
     * @param argument The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
     */
    @JvmName("hgsojqbmficblmqo")
    public suspend fun bgpPeers(argument: List<suspend BgpPeerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { BgpPeerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.bgpPeers = mapped
    }

    /**
     * @param argument The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
     */
    @JvmName("oeyhdopkqeffehjo")
    public suspend fun bgpPeers(vararg argument: suspend BgpPeerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { BgpPeerArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.bgpPeers = mapped
    }

    /**
     * @param argument The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
     */
    @JvmName("smvekuvkvopyvrlh")
    public suspend fun bgpPeers(argument: suspend BgpPeerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(BgpPeerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.bgpPeers = mapped
    }

    /**
     * @param values The list of BgpPeer entities that the Hybrid AKS cluster will peer with in addition to peering that occurs automatically with the switch fabric.
     */
    @JvmName("jyuwkgvmgxcgtvcv")
    public suspend fun bgpPeers(vararg values: BgpPeerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bgpPeers = mapped
    }

    /**
     * @param value The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
     * communities that should be associated with that prefix when it is announced.
     */
    @JvmName("ulfytignonxbjygg")
    public suspend fun communityAdvertisements(`value`: List<CommunityAdvertisementArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.communityAdvertisements = mapped
    }

    /**
     * @param argument The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
     * communities that should be associated with that prefix when it is announced.
     */
    @JvmName("xqftgolsprigpupb")
    public suspend
    fun communityAdvertisements(argument: List<suspend CommunityAdvertisementArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            CommunityAdvertisementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.communityAdvertisements = mapped
    }

    /**
     * @param argument The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
     * communities that should be associated with that prefix when it is announced.
     */
    @JvmName("ybssuusybdvbiysq")
    public suspend fun communityAdvertisements(
        vararg
        argument: suspend CommunityAdvertisementArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            CommunityAdvertisementArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.communityAdvertisements = mapped
    }

    /**
     * @param argument The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
     * communities that should be associated with that prefix when it is announced.
     */
    @JvmName("dkllngseietnhwto")
    public suspend
    fun communityAdvertisements(argument: suspend CommunityAdvertisementArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(CommunityAdvertisementArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.communityAdvertisements = mapped
    }

    /**
     * @param values The list of prefix community advertisement properties. Each prefix community specifies a prefix, and the
     * communities that should be associated with that prefix when it is announced.
     */
    @JvmName("owpwgemlcjhowyqh")
    public suspend fun communityAdvertisements(vararg values: CommunityAdvertisementArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.communityAdvertisements = mapped
    }

    /**
     * @param value The password of the Calico node mesh. It defaults to a randomly-generated string when not provided.
     */
    @JvmName("ytlqbfvjoulqtpgf")
    public suspend fun nodeMeshPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeMeshPassword = mapped
    }

    /**
     * @param value The subnet blocks in CIDR format for Kubernetes service external IPs to be advertised over BGP.
     */
    @JvmName("ppssdogpqokyotgh")
    public suspend fun serviceExternalPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceExternalPrefixes = mapped
    }

    /**
     * @param values The subnet blocks in CIDR format for Kubernetes service external IPs to be advertised over BGP.
     */
    @JvmName("hftbiraaxesyyvkl")
    public suspend fun serviceExternalPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceExternalPrefixes = mapped
    }

    /**
     * @param value The subnet blocks in CIDR format for Kubernetes load balancers. Load balancer IPs will only be advertised if they
     * are within one of these blocks.
     */
    @JvmName("dhclaaljatcttfoq")
    public suspend fun serviceLoadBalancerPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceLoadBalancerPrefixes = mapped
    }

    /**
     * @param values The subnet blocks in CIDR format for Kubernetes load balancers. Load balancer IPs will only be advertised if they
     * are within one of these blocks.
     */
    @JvmName("jeaelmwohtcsqgnq")
    public suspend fun serviceLoadBalancerPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceLoadBalancerPrefixes = mapped
    }

    internal fun build(): CniBgpConfigurationArgs = CniBgpConfigurationArgs(
        bgpPeers = bgpPeers,
        communityAdvertisements = communityAdvertisements,
        nodeMeshPassword = nodeMeshPassword,
        serviceExternalPrefixes = serviceExternalPrefixes,
        serviceLoadBalancerPrefixes = serviceLoadBalancerPrefixes,
    )
}
