@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.CommunityAdvertisementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property communities The list of community strings to announce with this prefix.
 * @property subnetPrefix The subnet in CIDR format for which properties should be advertised.
 */
public data class CommunityAdvertisementArgs(
    public val communities: Output<List<String>>,
    public val subnetPrefix: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.CommunityAdvertisementArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.CommunityAdvertisementArgs =
        com.pulumi.azurenative.networkcloud.inputs.CommunityAdvertisementArgs.builder()
            .communities(communities.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetPrefix(subnetPrefix.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CommunityAdvertisementArgs].
 */
@PulumiTagMarker
public class CommunityAdvertisementArgsBuilder internal constructor() {
    private var communities: Output<List<String>>? = null

    private var subnetPrefix: Output<String>? = null

    /**
     * @param value The list of community strings to announce with this prefix.
     */
    @JvmName("dndhmipwppklrwgy")
    public suspend fun communities(`value`: Output<List<String>>) {
        this.communities = value
    }

    @JvmName("bidwjmyqhubgwkph")
    public suspend fun communities(vararg values: Output<String>) {
        this.communities = Output.all(values.asList())
    }

    /**
     * @param values The list of community strings to announce with this prefix.
     */
    @JvmName("lgvwmpivpmxvnpro")
    public suspend fun communities(values: List<Output<String>>) {
        this.communities = Output.all(values)
    }

    /**
     * @param value The subnet in CIDR format for which properties should be advertised.
     */
    @JvmName("veieqebtosdchiwt")
    public suspend fun subnetPrefix(`value`: Output<String>) {
        this.subnetPrefix = value
    }

    /**
     * @param value The list of community strings to announce with this prefix.
     */
    @JvmName("nnrcgwsdcivglhry")
    public suspend fun communities(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.communities = mapped
    }

    /**
     * @param values The list of community strings to announce with this prefix.
     */
    @JvmName("ouknkpwntchcwved")
    public suspend fun communities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.communities = mapped
    }

    /**
     * @param value The subnet in CIDR format for which properties should be advertised.
     */
    @JvmName("ksxtqqiibluchdlf")
    public suspend fun subnetPrefix(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetPrefix = mapped
    }

    internal fun build(): CommunityAdvertisementArgs = CommunityAdvertisementArgs(
        communities = communities ?: throw PulumiNullFieldException("communities"),
        subnetPrefix = subnetPrefix ?: throw PulumiNullFieldException("subnetPrefix"),
    )
}
