@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.ControlPlaneNodeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property administratorConfiguration The administrator credentials to be used for the nodes in the control plane.
 * @property availabilityZones The list of availability zones of the Network Cloud cluster to be used for the provisioning of nodes in the control plane. If not specified, all availability zones will be used.
 * @property count The number of virtual machines that use this configuration.
 * @property vmSkuName The name of the VM SKU supplied during creation.
 */
public data class ControlPlaneNodeConfigurationArgs(
    public val administratorConfiguration: Output<AdministratorConfigurationArgs>? = null,
    public val availabilityZones: Output<List<String>>? = null,
    public val count: Output<Double>,
    public val vmSkuName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.ControlPlaneNodeConfigurationArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkcloud.inputs.ControlPlaneNodeConfigurationArgs =
        com.pulumi.azurenative.networkcloud.inputs.ControlPlaneNodeConfigurationArgs.builder()
            .administratorConfiguration(
                administratorConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .availabilityZones(availabilityZones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .count(count.applyValue({ args0 -> args0 }))
            .vmSkuName(vmSkuName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ControlPlaneNodeConfigurationArgs].
 */
@PulumiTagMarker
public class ControlPlaneNodeConfigurationArgsBuilder internal constructor() {
    private var administratorConfiguration: Output<AdministratorConfigurationArgs>? = null

    private var availabilityZones: Output<List<String>>? = null

    private var count: Output<Double>? = null

    private var vmSkuName: Output<String>? = null

    /**
     * @param value The administrator credentials to be used for the nodes in the control plane.
     */
    @JvmName("gfssnfdwyntncddb")
    public suspend fun administratorConfiguration(`value`: Output<AdministratorConfigurationArgs>) {
        this.administratorConfiguration = value
    }

    /**
     * @param value The list of availability zones of the Network Cloud cluster to be used for the provisioning of nodes in the control plane. If not specified, all availability zones will be used.
     */
    @JvmName("jmukvjdrdiiirnbe")
    public suspend fun availabilityZones(`value`: Output<List<String>>) {
        this.availabilityZones = value
    }

    @JvmName("cpclvnorbwahgswn")
    public suspend fun availabilityZones(vararg values: Output<String>) {
        this.availabilityZones = Output.all(values.asList())
    }

    /**
     * @param values The list of availability zones of the Network Cloud cluster to be used for the provisioning of nodes in the control plane. If not specified, all availability zones will be used.
     */
    @JvmName("bxrhyodpccwtveqi")
    public suspend fun availabilityZones(values: List<Output<String>>) {
        this.availabilityZones = Output.all(values)
    }

    /**
     * @param value The number of virtual machines that use this configuration.
     */
    @JvmName("upxfyoufjotpaknp")
    public suspend fun count(`value`: Output<Double>) {
        this.count = value
    }

    /**
     * @param value The name of the VM SKU supplied during creation.
     */
    @JvmName("ogkjpntufxfwaarv")
    public suspend fun vmSkuName(`value`: Output<String>) {
        this.vmSkuName = value
    }

    /**
     * @param value The administrator credentials to be used for the nodes in the control plane.
     */
    @JvmName("ptfywglnavchfesl")
    public suspend fun administratorConfiguration(`value`: AdministratorConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorConfiguration = mapped
    }

    /**
     * @param argument The administrator credentials to be used for the nodes in the control plane.
     */
    @JvmName("vtryuyjwkgfpftbl")
    public suspend
    fun administratorConfiguration(argument: suspend AdministratorConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = AdministratorConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.administratorConfiguration = mapped
    }

    /**
     * @param value The list of availability zones of the Network Cloud cluster to be used for the provisioning of nodes in the control plane. If not specified, all availability zones will be used.
     */
    @JvmName("ptosmvpdwgcnelij")
    public suspend fun availabilityZones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param values The list of availability zones of the Network Cloud cluster to be used for the provisioning of nodes in the control plane. If not specified, all availability zones will be used.
     */
    @JvmName("tjgvkujwavcymkte")
    public suspend fun availabilityZones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.availabilityZones = mapped
    }

    /**
     * @param value The number of virtual machines that use this configuration.
     */
    @JvmName("myblvuiowyfxntbq")
    public suspend fun count(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value The name of the VM SKU supplied during creation.
     */
    @JvmName("lbmtakbrilfuxowi")
    public suspend fun vmSkuName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSkuName = mapped
    }

    internal fun build(): ControlPlaneNodeConfigurationArgs = ControlPlaneNodeConfigurationArgs(
        administratorConfiguration = administratorConfiguration,
        availabilityZones = availabilityZones,
        count = count ?: throw PulumiNullFieldException("count"),
        vmSkuName = vmSkuName ?: throw PulumiNullFieldException("vmSkuName"),
    )
}
